% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-stan.R
\name{extract_parameters_from_draw}
\alias{extract_parameters_from_draw}
\title{Extract parameters from a single draw}
\usage{
extract_parameters_from_draw(fit, param, draw)
}
\arguments{
\item{fit}{Stanfit object.}

\item{param}{Vector of parameter names.}

\item{draw}{Index of the draw to extract the parameters from.}
}
\value{
Dataframe
}
\description{
Extract parameters from a single draw
}
\section{Note}{

Useful for to generate fake data.
}

\section{Alternative}{

The 'tidybayes' package offers an alternative to this function, for example:

\code{fit \%>\% tidy_draws() \%>\% gather_variables() \%>\% filter(.draw == draw & .variable \%in\% param)}

However, the 'tidybayes' version is less efficient as all draws and parameters are extracted and then filtered (also the draw IDs are not the same).
Using 'tidybayes' would be more recommended when we only want to extract specific parameters,
and that it does not matter which draw are extracted (in that case using \code{tidybayes::spread_draws()}).
}

\keyword{internal}
