% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurrecon.R
\name{hurrecon_set_path}
\alias{hurrecon_set_path}
\alias{hurrecon_get_path}
\alias{hurrecon_create_land_water}
\alias{hurrecon_reformat_hurdat2}
\alias{hurrecon_extract_tracks}
\title{Utility Functions}
\usage{
hurrecon_set_path(hur_path)

hurrecon_get_path()

hurrecon_create_land_water(
  nrows,
  ncols,
  xmin,
  xmax,
  ymin,
  ymax,
  save = TRUE,
  hur_path = NULL
)

hurrecon_reformat_hurdat2(path, hurdat2_file, save = TRUE)

hurrecon_extract_tracks(
  margin = 0,
  wind_min = 33,
  status = TRUE,
  save = TRUE,
  hur_path = NULL
)
}
\arguments{
\item{hur_path}{path for current set of model runs}

\item{nrows}{number of rows}

\item{ncols}{number of columns}

\item{xmin}{minimum longitude (degrees)}

\item{xmax}{maximum longitude (degrees)}

\item{ymin}{minimum latitude (degrees)}

\item{ymax}{maximum latitude (degrees)}

\item{save}{whether to save results to CSV files}

\item{path}{path for input & output files}

\item{hurdat2_file}{name of HURDAT2 file}

\item{margin}{an optional extension of the geographic window set by the
land-water file (degrees)}

\item{wind_min}{the minimum value of maximum sustained wind speed 
(meters/second)}

\item{status}{whether to limit search to storms with hurricane status}
}
\value{
no return value

current path

land-water raster

a data frame of track data

a list of three track-related data frames
}
\description{
hurrecon_set_path sets the path for the current set of model runs.

hurrecon_get_path returns the current path for a set of model runs.

hurrecon_create_land_water creates a land-water raster file in GeoTiff 
format from boundary files in shapefile format. The land-water file
(land_water.tif) is assumed to be aligned with lines of latitude and 
longitude.  Boundary files are assumed to be named boundary.* on the vector 
subdirectory. This function requires a reclasification file (reclassify.csv)
on the vector subdirectory. For more details, see documentation for the 
terra::classify function. The land-water file is created on the input 
subdirectory with the following values: 1=water, 2=land.

hurrecon_reformat_hurdat2 reformats a HURDAT2 file from the National 
Hurricane Center for use with the HURRECON model. The input file is assumed
to be in space-delimited text format. The output file (hurdat2_tracks.csv)
contains full track information for each hurricane plus columns for standard 
datetime and Julian day with fraction. Hurricane IDs are reformatted to
facilitate sorting by year. The user must specify the path and the name
of the HURDAT2 file.

hurrecon_extract_tracks extracts track data from an input track file
(input_tracks.csv) created from HURDAT2 using hurrecon_reformat_hurdat2
or created from other sources with the same file structure. The geographic 
window used to select hurricanes is set by the land-water file and is optionally
extended by the margin parameter. Selection begins by identifying all positions
in the window where winds reach or exceed hurricane speed (33 meters/second). 
If at least one such position exists, the track is extended to include one 
position before and one position after the first and last hurricane position 
in the window, if possible. If the resulting track contains at least two positions 
and the maximum sustained wind speed equals or exceeds wind_min, the track is 
included. For included storms, summary data are written to ids.csv, track data 
are written to tracks.csv, and track data for all positions are written to 
tracks_all.csv.
}
