% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_beta_coeff_functions.R
\name{data_beta_coeff_booster}
\alias{data_beta_coeff_booster}
\title{Obtain Booster Model Beta Corrections for tabular data}
\usage{
data_beta_coeff_booster(data, beta_corrections, iblm_model)
}
\arguments{
\item{data}{A data frame containing the dataset for analysis}

\item{beta_corrections}{A data frame or matrix containing beta correction values for all variables and bias}

\item{iblm_model}{Object of class 'iblm'}
}
\value{
A data frame with beta coefficient corrections. The structure will be the same dimension as `data` except for a "bias" column at the start.
}
\description{
Creates dataframe of Shap beta corrections for each row and predictor variable of `data`
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

explainer_outputs <- explain_iblm(iblm_model, df_list$test)

data_booster <- data_beta_coeff_booster(
  df_list$test,
  explainer_outputs$beta_corrections,
  iblm_model
)

data_booster |> dplyr::glimpse()

}
