% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramsUtils.R
\name{pclrange}
\alias{pclrange}
\alias{pcrange}
\title{Penalized Complexity (PC) prior for (log) range}
\usage{
pclrange(lrange, lam, d = 2, logdens = FALSE)

pcrange(range, lam, d = 2, logdens = FALSE)
}
\arguments{
\item{lrange}{numeric with the log of the (practical) range}

\item{lam}{numeric with the prior parameter}

\item{d}{integer to specify the domain dimention}

\item{logdens}{logical indicating if the density
is to be returned in the log scale}

\item{range}{numeric with the of the (practical) range}
}
\description{
Penalized Complexity (PC) prior for (log) range
}
\examples{
# P(range < 2.0) = 0.1
 lam <- -log(0.1) * 2.0
 plot(function(x) pcrange(x, lam), 1/100, 10, n = 100)
}
