% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_database.R
\name{update_database}
\alias{update_database}
\title{Update database}
\usage{
update_database(
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  datasets_name = c(open = "open_issues.yaml", closed = "closed_issues.yaml", labels =
    "list_labels.yaml", milestones = "list_milestones.yaml"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dataset_dir}{A character string specifying the path which contains the
datasets (only taken into account if \code{source} is set to \code{"local"}).
Defaults to the package option \code{IssueTrackeR.dataset.dir}.}

\item{datasets_name}{A named character string of length 4, specifying the
names of the different datasets which will be written. The names
\code{datasets_name} have to be \code{"open"}, \code{"closed"},
\code{"labels"} and \code{"milestones"}.
Defaults to \code{
c(open = "open_issues.yaml",
  closed = "closed_issues.yaml",
  labels = "list_labels.yaml",
  milestones = "list_milestones.yaml")
}.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}

\item{\dots}{Additional arguments for connecting to the GitHub repository:
\itemize{
\item \code{repo} A character string specifying the GitHub repository name.
Defaults to the package option \code{IssueTrackeR.repo}.
\item \code{owner} A character string specifying the GitHub owner.
Defaults to the package option \code{IssueTrackeR.owner}.
(See the documentation of \code{\link[IssueTrackeR]{get}} to have more
information on theses parameters):
}}
}
\value{
invisibly (with \code{invisible()}) \code{TRUE}.
}
\description{
Update the different local database (issues, labels and milestones) with the
online reference.
}
\examples{

\dontrun{
update_database(dataset_dir = tempdir())
}

}
