% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JATS_get.keywords.R
\name{get.keywords}
\alias{get.keywords}
\title{get.keywords}
\usage{
get.keywords(
  x,
  paste = "",
  letter.convert = TRUE,
  include.max = length(keyword)
)
}
\arguments{
\item{x}{a NISO-JATS coded XML file or text.}

\item{paste}{if paste!="" keyword list is collapsed to one cell with seperator specified (e.g. paste=";").}

\item{letter.convert}{Logical. If TRUE converts hexadecimal and HTML coded characters to Unicode.}

\item{include.max}{a maximum number of keywords to extract.}
}
\value{
Character vector with extracted keyword/s.
}
\description{
Extracts keyword tag/s from NISO-JATS coded XML file or text as vector of keywords.
}
\examples{
x<-"Some text <kwd>Keyword 1</kwd>, <kwd>Keyword 2</kwd> some text"
get.keywords(x)
get.keywords(x,paste(", "))
}
\seealso{
\code{\link[JATSdecoder]{JATSdecoder}} for simultaneous extraction of meta-tags, abstract, sectioned text and reference list.
}
