% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{kojima_tweets_tbl_df}
\alias{kojima_tweets_tbl_df}
\title{Kojima Hideo Tweets (Japanese)}
\format{
A tibble with 454 observations and 41 variables:
\describe{
  \item{Tweet}{Text content of the tweet (character)}
  \item{Created Date}{Date when the tweet was created (character)}
  \item{Retweets}{Number of retweets (numeric)}
  \item{Favourites}{Number of likes (numeric)}
  \item{Engagement}{Sum of retweets and likes (numeric)}
  \item{No of Hashtags}{Count of hashtags used (numeric)}
  \item{No of User Mentions}{Count of user mentions (numeric)}
  \item{No of URLS added}{Count of URLs included (numeric)}
  \item{No of Media added}{Count of media elements attached (numeric)}
  \item{Tweeted Username}{Username who posted the tweet (character)}
  \item{Replied To Username}{Whether it was a reply to another user (logical)}
  \item{Post Type}{Type of post (e.g., tweet, reply, etc.) (character)}
  \item{Media Type}{Type of media included (e.g., photo, video) (character)}
  \item{Is Quote Tweet}{Whether the tweet is a quote (character)}
  \item{Is Retweeted}{Whether the tweet is a retweet (character)}
  \item{Language (Tweets)}{Language of the tweet content (character)}
  \item{Country}{Country information if available (logical)}
  \item{Location (Tweets)}{Geolocation as specified in the tweet (logical)}
  \item{Location Full Name}{Full name of the location (logical)}
  \item{Location Type}{Type of location (logical)}
  \item{Hashtags}{Hashtags used in the tweet (character)}
  \item{User Mentions}{User mentions in the tweet (character)}
  \item{URLS Used}{URLs present in the tweet (character)}
  \item{Media URLS}{Media URLs attached to the tweet (character)}
  \item{Name}{Name associated with the Twitter account (character)}
  \item{Username}{Handle of the Twitter account (character)}
  \item{Created Date (Handles)}{Date when the Twitter account was created (character)}
  \item{Language (Handles)}{Preferred language of the account (character)}
  \item{Tweets}{Total number of tweets from the account (numeric)}
  \item{Followers}{Number of followers (numeric)}
  \item{Friends}{Number of accounts followed (numeric)}
  \item{Favourites (Handles)}{Total number of liked tweets by the account (numeric)}
  \item{Listed Count}{Number of lists the account is included in (numeric)}
  \item{Location (Handles)}{Location listed in the user profile (character)}
  \item{Protected}{Whether the account is protected (character)}
  \item{Verified}{Whether the account is verified (character)}
  \item{URL}{URL included in the profile (character)}
  \item{Description}{Profile description or bio (character)}
  \item{Profile Image URL}{URL of the profile image (character)}
  \item{Account Age in Days}{Age of the account in days (numeric)}
  \item{Avg Tweets per day}{Average tweets per day (numeric)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/luciesteel/kojima-tweets}
}
\usage{
data(kojima_tweets_tbl_df)
}
\description{
This dataset, kojima_tweets_tbl_df, is a tibble containing 454 original tweets from Hideo Kojima,
posted between November 17, 2019, and January 6, 2020. Retweets are excluded.
The dataset includes tweet text, engagement metrics, tweet metadata, user handle information,
geolocation data, hashtags, mentions, URLs, and media details. The dataset preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'kojima_tweets_tbl_df' to maintain consistency with the naming conventions
in the JapanAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame. The original content
has not been modified in any way.
}
