% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{juliaGet}
\alias{juliaGet}
\title{Translate a Julia proxy object to an R object}
\usage{
juliaGet(x)
}
\arguments{
\item{x}{a reference to a Julia object}
}
\description{
R objects of class \code{JuliaProxy} are references to Julia objects in the Julia session.
These R objects are also called "proxy objects".
With this function it is possible to translate these objects into R objects.
}
\details{
If the corresponding Julia objects do not contain external references,
translated objects can also saved in R and safely be restored in Julia.

Modifying objects is possible and changes in R will be translated back to Julia.

The following table shows the translation of Julia objects into R objects.

\tabular{lcl}{
\strong{Julia} \tab  \tab \strong{R} \cr
 \code{struct} \tab \eqn{\rightarrow}{-->} \tab \code{list} with the named struct elements \cr
 \code{Array} of \code{struct} type \tab \eqn{\rightarrow}{-->} \tab \code{list} (of \code{list}s) \cr
 \code{Tuple} \tab \eqn{\rightarrow}{-->} \tab \code{list} \cr
 \code{NamedTuple} \tab \eqn{\rightarrow}{-->} \tab \code{list} with the named elements \cr
 \code{AbstractDict} \tab \eqn{\rightarrow}{-->} \tab \code{list} with two sub-lists: "\code{keys}" and "\code{values}" \cr
 \code{AbstractSet} \tab \eqn{\rightarrow}{-->} \tab \code{list} \cr
}
}
\note{
Objects containing circular references cannot be translated back to Julia.

It is safe to translate objects that contain external references from Julia to R.
The pointers will be copied as values and the finalization of the translated
Julia objects is prevented.
The original objects are garbage collected after all direct or
indirect copies are garbage collected.
Note, however, that these translated objects cannot be translated back to Julia
after the Julia process has been stopped and restarted.
}
