# KWELA <img src="man/figures/logo.png" align="right" height="139" />
<!-- badges: start -->
[![CRAN status](https://www.r-pkg.org/badges/version/KWELA)](https://CRAN.R-project.org/package=KWELA)
[![R-CMD-check](https://github.com/RFeissIV/KWELA/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/RFeissIV/KWELA/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

**KWELA** extends RT-QuIC (Real-Time Quaking-Induced Conversion) statistical analysis to complex environmental matrices through hierarchical adaptive classification.

KWELA is named after a deity of the Fore people of Papua New Guinea, among whom Kuru, a notable human prion disease, was identified.

## Installation

```r
# Install from CRAN
install.packages("KWELA")

# Or install development version from GitHub
# install.packages("devtools")
devtools::install_github("RFeissIV/KWELA")
```

## 6-Layer Architecture

KWELA implements a hierarchical adaptive classification system with dual-mode operation:

| Layer | Function | Description |
|-------|----------|-------------|
| 1 | **Hard Gate** | Biological constraint filter with stochastic rescue (research mode) |
| 2 | **Per-Well Scoring** | Profile-dependent adaptive transforms |
| 3 | **Adaptive Combination** | Separation-aware score combiner |
| 4 | **Adaptive Cutoff** | Youden-optimized threshold per plate |
| 5 | **Replicate Consensus** | Treatment-level classification |
| 6 | **Instability Detection** | Matrix interference override |

## Quick Start

```r
library(KWELA)

# Diagnostic mode (default) — deterministic, no stochastic rescue
result <- kwela_analyze(your_data)

# Research mode — full adaptive architecture
result <- kwela_analyze(your_data, mode = "research")

# Get treatment-level summary
summary <- kwela_summarize(result)

# View diagnostics (includes instability flags)
diag <- kwela_diagnostics(result)
```

## Dual-Mode Operation

| Feature | Diagnostic (default) | Research |
|---------|---------------------|----------|
| Stochastic rescue | Disabled | Enabled |
| Stochastic score in combiner | Excluded | Included |
| TTT/MP/RAF scoring | Full | Full |
| Instability detection | Enabled | Enabled |

## Profiles

| Profile | When to Use | Cohen's d |
|---------|-------------|-----------|
| `standard` | Clean assay, strong separation | > 3.0 |
| `sensitive` | Spiked samples, moderate separation | 1.5 - 3.0 |
| `matrix_robust` | Environmental matrices, poor separation | < 1.5 |
| `auto` | Let KWELA decide based on data | - |

## Consensus Rules

| Rule | Classification Criteria |
|------|------------------------|
| `strict` | All wells must be positive |
| `majority` | >50% of wells positive (default) |
| `flexible` | Any well positive |
| `threshold` | Mean score >= threshold |

## Key Features

- **Dual-mode operation**: diagnostic (deterministic) vs research (adaptive)
- **Instability detection**: 6 deterministic metrics for matrix interference
- **Auto-profile selection** based on PC/NC separation quality
- **RAF integration** for artifact detection and quality scoring
- **Group-aware mixed-assay support** (RT-QuIC + Nano-QuIC)
- **Matrix-aware baseline correction** with per-group local controls
- **Comprehensive metrics**: CRPS, Wasserstein, Energy distance, SSMD, JSD

## Citation

If you use KWELA in your research, please cite:

```
Feiss RA IV (2026). KWELA: Hierarchical Adaptive RT-QuIC Classification.
R package version 1.0.0. https://CRAN.R-project.org/package=KWELA
```

## Note

This package implements methodology currently under peer review. Please contact the author before publication using this approach.

## Development & AI Disclosure

Development followed an iterative human-machine collaboration where all algorithmic design, statistical methodologies, and biological validation logic were conceptualized, tested, and iteratively refined by Richard A. Feiss through repeated cycles of running experimental data, evaluating analytical outputs, and selecting among candidate algorithms and approaches. AI systems (Anthropic Claude and OpenAI GPT) served as coding assistants and analytical sounding boards under continuous human direction. The selection of statistical methods, evaluation of biological plausibility, and all final methodology decisions were made by the human author. AI systems did not independently originate algorithms, statistical approaches, or scientific methodologies.

## License

MIT © Richard A. Feiss IV
