% Generated by roxygen2: do not edit by hand
\name{entropy}
\alias{entropy}
\alias{jensen_shannon}
\title{Information-Theoretic Metrics}
\usage{
entropy(x, n_bins = 10)

jensen_shannon(p, q, n_bins = 15)
}
\arguments{
\item{x}{Numeric vector}

\item{n_bins}{Number of histogram bins}

\item{p}{First distribution (numeric vector)}

\item{q}{Second distribution (numeric vector)}
}
\value{
\code{entropy} returns entropy in nats, or \code{NA_real_} if fewer
than 3 values.

\code{jensen_shannon} returns JSD bounded in [0, ln(2)], or \code{NA_real_}
if either distribution has fewer than 5 values.
}
\description{
\code{entropy} computes Shannon entropy from discretized distribution.

\code{jensen_shannon} computes symmetric Jensen-Shannon divergence
with Laplace smoothing.
}
\references{
Lin J (1991). Divergence measures based on the Shannon entropy.
IEEE Transactions on Information Theory 37(1):145-151.
}
\examples{
entropy(rnorm(100))

set.seed(42)
p <- rnorm(50, 0, 1)
q <- rnorm(50, 2, 1)
jensen_shannon(p, q)
}
