% Generated by roxygen2: do not edit by hand
\name{cv}
\alias{cv}
\alias{fano_factor}
\alias{ssmd}
\alias{normalized_stochastic_index}
\alias{snr_vs_control}
\title{Stochasticity Metrics}
\usage{
cv(x)

fano_factor(x)

ssmd(treatment, control)

normalized_stochastic_index(treatment_var, pc_var, nc_var)

snr_vs_control(treatment, control)
}
\arguments{
\item{x}{Numeric vector}

\item{treatment}{Numeric vector of treatment values}

\item{control}{Numeric vector of control values}

\item{treatment_var}{Treatment variance}

\item{pc_var}{Positive control variance}

\item{nc_var}{Negative control variance}
}
\value{
All functions return a single numeric value or \code{NA_real_} if
insufficient data.

\code{cv} returns the coefficient of variation (MAD-based).

\code{fano_factor} returns the variance-to-mean ratio.

\code{ssmd} returns the strictly standardized mean difference.

\code{normalized_stochastic_index} returns a value in [0, 1].

\code{snr_vs_control} returns the signal-to-noise ratio.
}
\description{
Functions for quantifying stochastic variability in RT-QuIC data.
}
\references{
Zhang XHD (2007). A pair of new statistical parameters for quality control
in RNA interference high-throughput screening assays. Genomics 89(4):552-61.
}
\examples{
set.seed(42)
x <- rnorm(30, 10, 2)
y <- rnorm(30, 5, 2)

cv(x)
fano_factor(x + 10)
ssmd(x, y)
snr_vs_control(x, y)
normalized_stochastic_index(var(x), 4, 1)
}
