% Generated by roxygen2: do not edit by hand
\name{kwela_summarize}
\alias{kwela_summarize}
\alias{kwela_diagnostics}
\title{KWELA Summary and Diagnostics}
\usage{
kwela_summarize(result)

kwela_diagnostics(result)
}
\arguments{
\item{result}{Output from \code{kwela_analyze}}
}
\value{
\code{kwela_summarize} returns a data frame with treatment-level results:
\describe{
  \item{Treatment}{Treatment name}
  \item{n_wells}{Number of wells}
  \item{n_positive}{Number of positive wells}
  \item{positive_rate}{Fraction positive}
  \item{mean_score}{Mean well score}
  \item{classification}{Treatment classification}
  \item{confidence}{Confidence level}
  \item{consensus_rule}{Consensus rule used}
  \item{is_spiked}{Whether treatment is spiked}
}

\code{kwela_diagnostics} returns a list with:
\describe{
  \item{version}{KWELA version string}
  \item{mode}{Analysis mode ("diagnostic" or "research")}
  \item{profile}{Profile used}
  \item{consensus}{Consensus rule used}
  \item{optimal_cutoff}{Youden-optimized cutoff}
  \item{youden_j}{Youden J statistic}
  \item{separation}{Separation quality metrics}
  \item{well_level}{Well-level statistics}
  \item{treatment_level}{Treatment-level statistics}
  \item{instability}{Instability detection results: check_enabled, strictness, n_inconclusive_matrix, treatments_flagged}
  \item{n_samples}{Number of sample wells}
  \item{n_spiked}{Number of spiked wells}
  \item{n_unspiked}{Number of unspiked wells}
}
}
\description{
\code{kwela_summarize} extracts treatment-level consensus results.

\code{kwela_diagnostics} returns detailed diagnostic information.
}
\examples{
\donttest{
set.seed(42)
df <- data.frame(
  Treatment = c(rep("Positive Control", 8), rep("Negative Control", 8),
                rep("Sample_A", 8)),
  TTT = c(rnorm(8, 8, 1), rnorm(8, 72, 5), rnorm(8, 12, 3)),
  MP = c(rnorm(8, 100, 10), rnorm(8, 20, 5), rnorm(8, 85, 15))
)
result <- kwela_analyze(df, verbose = FALSE)
summary <- kwela_summarize(result)
diag <- kwela_diagnostics(result)
}
}
