% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/US_data_CoD.R
\docType{data}
\name{US_data_CoD}
\alias{US_data_CoD}
\title{US cause-of-death Mortality data}
\format{
A data frame with 80598 rows and 8 columns with class \code{"LEdecompData"} and \code{"data.frame"} including the following information
\itemize{
\item \code{Age} a vector containing the ages considered in the dataset, 0, 1, ..., 99, and 100.
\item \code{Gender} a vector containing the information regarding the gender, \code{"Male"} or \code{"Female"}.
\item \code{Period} a vector containing the periods of the dataset from 2000 to 2020.
\item \code{Ext} a vector containing the size of the population at risk of death by age and period.
\item \code{Dxt} a vector containing the number of registered deaths by age and period.
\item \code{mxt} a vector mortality rates for the corresponding age and period.
\item \code{cause} a vector containing a brief summary of the corresponding cause of death.
\item \code{cause_id} a vector containing the corresponding identification number for the cause of death.
}
}
\usage{
US_data_CoD
}
\description{
Data from the US total population from the Human Mortality Dataset and from National Center for Health Statistics (NCHS).
In this case, we have information with the number of deaths by 18 different causes, for more information please review the cause_id and the National Center for Health Statistics (NCHS).
The use of two dataset is justified because NCHS does not contain information of exposures above age 85.
The dataset contains information on mortality rates (mxt), registered deaths (Dxt) and the size of the population at risk of death (Ext) by period, from 2000 to 2020, and by age, from 0 to 100 years, for both males and females.
In addition, we have the number of deaths by cause between 0 and 100 years of age and between 2000 and 2020.
}
\examples{
#The dataset is executed with the following information
US_data_CoD

}
\keyword{datasets}
