% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arriaga.R
\name{sen_arriaga_sym_instantaneous}
\alias{sen_arriaga_sym_instantaneous}
\title{Instantaneous sensitivity via symmetrical Arriaga decomposition}
\usage{
sen_arriaga_sym_instantaneous(
  mx,
  age = 0:(length(mx1) - 1),
  sex = "t",
  nx = rep(1, length(mx)),
  perturb = 1e-06,
  closeout = TRUE
)
}
\arguments{
\item{mx}{Numeric vector of mortality rates (central death rates).}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{sex}{Character; "m" for male, "f" for female, or "t" for total.}

\item{nx}{integer vector of age intervals, default 1.}

\item{perturb}{Numeric; a small constant determining the perturbation size (default 1e-6).}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of life expectancy sensitivity to perturbations in \code{mx.}
}
\description{
Estimates the sensitivity of life expectancy to small changes in age-specific mortality rates using the symmetrical Arriaga decomposition. This is done by applying a small multiplicative perturbation to the input mortality rates and using the symmetrical sensitivity function \code{sen_arriaga_sym()}.

Specifically, the function constructs:
\deqn{m_{x}^{1} = m_x \cdot \left(\frac{1}{1 - h}\right)}
\deqn{m_{x}^{2} = m_x \cdot (1 - h)}
and applies \code{sen_arriaga_sym(mx1, mx2, ...)} to the result.
}
\details{
This function yields an instantaneous approximation to the derivative of life expectancy with respect to mortality, evaluated at the input schedule. Because \code{sen_arriaga_sym()} is itself symmetrical, only the "forward" perturbation is required.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx <- a * exp(x * b)
s <- sen_arriaga_sym_instantaneous(mx, age = x)
\donttest{
plot(x, s, type = "l")
}
}
\seealso{
\code{\link{sen_arriaga_sym}}, \code{\link{sen_arriaga_sym_instantaneous2}}, \code{\link{sen_lopez_ruzicka_instantaneous}}
}
