% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_opt.R
\name{sen_min}
\alias{sen_min}
\title{sen_min}
\usage{
sen_min(
  mx1,
  mx2,
  age,
  sex1,
  sex2 = sex1,
  closeout = TRUE,
  sen_fun = sen_arriaga_instantaneous,
  tol = 1e-10,
  ...
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}

\item{sen_fun}{function name, current options include \code{sen_arriaga_instantaneous}, \code{sen_arriaga_instantaneous1}, \code{sen_arriaga_sym}, \code{sen_e0_mx_lt},  \code{sen_num}}

\item{tol}{double. tolerance level for residual, passed to \code{optimise()}}

\item{...}{optional arguments to pass to \code{sen_fun()}}
}
\value{
age-specific sensitivity of life expectancy to changes in mortality rates.
}
\description{
Most sensitivity methods in this packages (\code{sen_arriaga_sym()} excepted) are approximations; when used in decompositions they will tend to imply residuals. To acheive near-exact additivity for a decomposition using these sensitivity approaches, one can try to find a different weighting of rates from populations 1 and 2, rather than simply taking their arithmetic average. Here we turn this into an optimization problem, where we find the weighting \code{w} that implies an exactly additive decomposition to an arbitrary degree of tolerance.
\deqn{m_{x} = m_{x}^{1} * w + m_{x}^{2} * (1-w)}
}
\details{
We expect the value \code{w} to be close to .5, and only search the interval \verb{[.4,.6]}. This may need to be revisited in case that proves too narrow.
}
\examples{
a   <- .001
b   <- .07
x   <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
mx  <- (mx1 + mx2) / 2
s1 <- sen_min(mx1, mx2,
              age = x, sex1 = 't',
              closeout = TRUE,
              sen_fun = sen_arriaga_instantaneous)
s2 <- sen_min(mx1, mx2,
              age = x, sex1 = 't',
              closeout = TRUE,
              sen_fun = sen_e0_mx_lt,
              tol = 1e-12)

# check sums
e01 <- mx_to_e0(mx1,age=x,sex='t',closeout=TRUE)
e02 <- mx_to_e0(mx2,age=x,sex='t',closeout=TRUE)
(gap <- e02 - e01)
delta <- mx2 - mx1
(gap1 <- sum(s1 * delta))
(gap2 <- sum(s2 * delta))
gap2-gap

plot(x, s1, type= 'l')
lines(x, s2, col = 'red', lty = 2, lwd = 2)

plot(x, s2-s1, main = "age 0 difference is due to imprecision in
lifetable approach for this age")
}
