% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{fitted.LMMsolve}
\alias{fitted.LMMsolve}
\title{Fitted values of an LMMsolve object.}
\usage{
\method{fitted}{LMMsolve}(object, ...)
}
\arguments{
\item{object}{an object of class LMMsolve}

\item{...}{some methods for this generic require additional arguments.
None are used in this method.}
}
\value{
A vector of fitted values.
}
\description{
Obtain the fitted values from a mixed model fitted using LMMSolve.
}
\examples{
## Fit model on oats data
data(oats.data)

## Fit simple model with only fixed effects.
LMM1 <- LMMsolve(fixed = yield ~ rep + gen,
                data = oats.data)

## Obtain fitted values.
fitted1 <- fitted(LMM1)

}
