LSMselect=function(X,maxDims=3,nfolds=5,penalty=NULL,C=NULL,starts=NULL,tol=.1,silent=TRUE){
  if((!is.null(penalty))&(!is.null(C))) stop("LSMselect has not been implemented yet for constrained estimation")
  if(is.null(penalty)&is.null(C)){
    penalty=1
    C=NULL
  }
  if(is.null(penalty)&(!is.null(C))) stop("LSMselect has not been implemented yet for constrained estimation")
  if((!is.null(penalty))&is.null(C)) C=NULL
  if(!is.matrix(X)) stop("X should be a matrix")
  N=nrow(X)
  nit=nit0=ncol(X)
  if(!all(apply(X,2,min,na.rm=TRUE)==rep(0,nit))) stop("data should be coded so that the lowest score is 0 for each item")
  nc=apply(X,2,max,na.rm=TRUE)+1
  if(!all(nc==rep(2,nit))) GRM=TRUE else GRM=FALSE

  J=matrix(0,nit0,sum(nc-1))
  for(i in 1:nit0)
    for(c in 1:(nc[i]-1)){
      if(i==1) J[i,c]=1
      if(i>1) J[i,sum(nc[1:(i-1)]-1)+c]=1
    }

  if(GRM){
    X2=matrix(,N,sum(nc-1))
    dummy0=dummy1=rep(0,max(nc-1))
    for(p in 1:N)
      for(i in 1:nit)
        if(!is.na(X[p,i])){
          dummy1=dummy0[1:(nc[i]-1)]
          if(X[p,i]>0) dummy1[seq(1,X[p,i])]=1
          if(i>1) X2[p,(sum(nc[1:(i-1)]-1)+1):(sum(nc[1:i]-1))]=dummy1
          if(i==1) X2[p,1:(nc[i]-1)]=dummy1
        }
  }

  if(maxDims<1) stop("maxDims should at least be 1")
  dims=maxDims:0
  t0=Sys.time()

  n_data=length(X[!is.na(X)])
  all_data_index=(1:n_data)[!is.na(X)]
  size_folds=rep(n_data%/%nfolds,nfolds)
  if((n_data%%nfolds)>0) size_folds[1:(n_data%%nfolds)]=size_folds[1:(n_data%%nfolds)]+1

  folds=matrix(,nfolds,max(size_folds))
  all_folds=sample(all_data_index,n_data,replace=FALSE)

  for(f in 1:nfolds){
    folds[f,1:size_folds[f]]=all_folds[1:size_folds[f]]
    all_folds=all_folds[-(1:size_folds[f])]
  }

  SFP_f=SAOC_f=SSE_f=matrix(,nfolds,length(dims))
  SFP_f2=SAOC_f2=SSE_f2=matrix(,nfolds,length(dims))

  colnames(SFP_f)=colnames(SAOC_f)=colnames(SSE_f)=paste0(maxDims:0," dim")
  rownames(SFP_f)=rownames(SAOC_f)=rownames(SSE_f)=paste0("Fold ",1:nfolds)


  if(!is.list(starts)){
    if(is.null(starts)) starts_all=LSMstartsML(X,maxDims,J,nc,random=FALSE,silent=silent)
    else {
      if(starts=="wls") starts_all=LSMstarts(X,maxDims,J,nc,random=FALSE,silent=silent)
      if(starts=="ml") starts_all=LSMstartsML(X,maxDims,J,nc,random=FALSE,silent=silent)
      if(starts=="random") starts_all=LSMstarts(X,maxDims,J,nc,random=TRUE,silent=silent)
    }
  } else if(is.list(starts)) starts_all=starts

  for(f in 1:nfolds){
    X_val=X
    X_val[stats::na.omit(folds[f,])]=NA
    if(f>1 | (!silent)) cat("\n")
    cat("** Fold:",f,"**")
    if(!silent) cat("\n")

    for(d in 1:length(dims)){
      if(silent) cat("  ")
      if(!silent) cat("\n")
      cat("--model dim:",dims[d])
      if(!silent) cat("\n\n")

      if(d==1) starts0=starts_all
      if(d>1){
        starts0=resLSM$as_starts
        if(dims[d]==0){
          starts0$z0=matrix(0,N)
          starts0$w0=matrix(0,nit)
        } else{
          starts0$z0=as.matrix(starts0$z0[,-(dims[d])])
          starts0$w0=as.matrix(starts0$w0[,-(dims[d])])
        }
      }

      resLSM=LSMfit(X_val,dims[d],starts=starts0,penalty=penalty,C=C,tol=tol,silent=silent)
      pred=LSMpred(resLSM$internal$theta,resLSM$internal$b,
                     resLSM$internal$z,resLSM$internal$w,dims[d],
                     penalty,resLSM$internal$C,resLSM$internal$X,resLSM$internal$U,N,resLSM$internal$nit)
      if(!GRM){
        SFP_f[f,d]=sum((X[stats::na.omit(folds[f,])]!=round(pred)[stats::na.omit(folds[f,])])*1)
        tmp <- pROC::roc(X[stats::na.omit(folds[f,])], pred[stats::na.omit(folds[f,])],quiet=TRUE)
        SAOC_f[f,d] = size_folds[f]  *(1-pROC::auc(tmp)[[1]][1])
        SSE_f[f,d]=sum((X[stats::na.omit(folds[f,])]- pred[stats::na.omit(folds[f,])])^2)
      }
      if(GRM){
        U=resLSM$internal$U
        U[is.na(X2)]=1
        SFP_f2[f,d]=sum((X2[U==0]!=round(pred)[U==0])*1)
        if(GRM) tmp <- pROC::roc(X2[U==0], pred[U==0],quiet=TRUE)
        SAOC_f2[f,d] = size_folds[f]  *(1-pROC::auc(tmp)[[1]][1])
        SSE_f2[f,d]=sum((X2[U==0]- pred[U==0])^2)
      }
    }}
  if(GRM){
    SFP_f=SFP_f2
    SAOC_f=SAOC_f2
    SSE_f=SSE_f2
  }
  output=cbind(colSums(SFP_f),colSums(SAOC_f),colSums(SSE_f))
  fold_res=list()
  fold_res$UCE=SFP_f[,(maxDims+1):1]
  fold_res$URE=SAOC_f[,(maxDims+1):1]
  fold_res$RSS=SSE_f[,(maxDims+1):1]

  colnames(output)=c("UCE","URE","RSS")
  rownames(output)=paste(dims,"dim")
  time=Sys.time()-t0
  cat("\n**Overall time taken:",time,units(time),"\n\n")

  results=list(tot_metrics=output[nrow(output):1,],fold_metrics=fold_res)
  class(results)="LSMselect"
  return(results)
}
