#include <RcppArmadillo.h>

using namespace std;
// [[Rcpp::depends(RcppArmadillo)]]

arma::mat calc_dist(const arma::mat z,const arma::mat w, int ndim_z, double lambda, double C, int N, int nit){
  arma::mat tmp(N,nit,arma::fill::zeros);
  for(int s=0; s<ndim_z; s++) tmp+=pow(z.cols(s+s,s+s+1)*w.cols(s+s,s+s+1).t(),2);
  return(sqrt(tmp));
}

// [[Rcpp::export]]
arma::rowvec project_pers(const arma::rowvec &x, double ndim_z, double C){
  double norm_sq = (arma::accu(x%x))-(ndim_z+1);
  if(norm_sq<=(C*C/4)) return(x);
  else{
    arma::rowvec y=x*sqrt((C*C/4)/norm_sq);
    return(y);
  }
}


// [[Rcpp::export]]
arma::rowvec project_item(const arma::rowvec &x, double ndim_z, double C, double mb){
  double norm_sq = (arma::accu(x%x))-(ndim_z+1)-2*mb*x(0)+mb*mb;
  if(norm_sq<=(C*C)) return(x);
  else{
    arma::rowvec y=x*sqrt((C*C)/norm_sq);
    y(0)=y(0)-mb*C/sqrt(norm_sq)+mb;
    return(y);
  }
}

// [[Rcpp::export]]
arma::rowvec project_item_ord(const arma::rowvec &x, double ndim_z, double C, double nc, double mb){
  double norm_sq = (arma::accu(x%x))-(ndim_z+nc-1);
  if(norm_sq<=(C*C)) return(x);
  else{
    arma::rowvec y=x*sqrt((C*C)/norm_sq);
    return(y);
  }
}




// [[Rcpp::export]]
arma::mat LSMpred(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  return(1/(1+exp(-(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit)))));
}

// [[Rcpp::export]]
arma::mat contrast(int k) {
  arma::mat I = arma::eye(k, k);
  if(k==1) return(I);
  arma::mat contr= -1*arma::diff(I, 1, 0);
  return(arma::trans(contr));
}

// [[Rcpp::export]]
double logl(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, const arma::mat &J,const arma::mat &J0, int N, int nit, int nit0){
  arma::mat tmp = -U%(2*X-1)%(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit));
  double penalty=0.0;
  if(lambda!=-1) penalty = -.5* arma::accu(((theta0.col(1) % theta0.col(1)))) +-.5* arma::accu(b0.col(0) % b0.col(0))
    + -.5*arma::accu(arma::pow(J0*w,2)) + -.5*arma::accu(z % z) +.5* (ndim_z*(N+nit0));
  return arma::accu(-U%log((1+exp(tmp)))) + lambda*penalty;
}


// [[Rcpp::export]]
double logl_p(const arma::rowvec &theta0, const arma::mat &b0, const arma::rowvec &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::rowvec &X, const arma::rowvec &U,const arma::mat &J,const arma::mat &J0, int N, int nit, int nit0){
  arma::mat tmp = -U%(2*X-1)%(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit));
  double penalty=0.0;
  if(lambda!=-1) penalty =  -.5*arma::accu(((theta0(1) * theta0(1)))) + -.5*arma::accu(b0.col(0) % b0.col(0))
    + -.5*arma::accu(arma::pow(J0*w,2)) + -.5*arma::accu(z % z) + .5*(ndim_z*(N+nit0));
  return arma::accu(-U%log((1+exp(tmp)))) + lambda*penalty ;
}

// [[Rcpp::export]]
double logl_i_ord(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U,const arma::mat &J,const arma::mat &J0, int N, int nit, int nit0){
  arma::mat tmp = -U%(2*X-1)%(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit));
  double penalty=0.0;
  if(lambda!=-1) penalty= -.5*arma::accu(((theta0.col(1) % theta0.col(1)))) + -.5*arma::accu(b0(0) * b0(0))
    + -.5*arma::accu(w.row(0) % w.row(0)) + -.5*arma::accu(z % z) +.5* (ndim_z*(N+nit0));
  return arma::accu(-U%log((1+exp(tmp))))+lambda*penalty ;
}

// [[Rcpp::export]]
double logl_i(const arma::mat &theta0, const arma::rowvec &b0, const arma::mat &z, const arma::rowvec &w, int ndim_z, double lambda, double C, const arma::vec &X, const arma::vec &U,const arma::mat &J,const arma::mat &J0, int N, int nit, int nit0){
  arma::mat tmp = -U%(2*X-1)%(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit));
  double penalty=0.0;
  if(lambda!=-1) penalty= -.5*arma::accu(((theta0.col(1) % theta0.col(1)))) + -.5*arma::accu(b0(0) * b0(0))
    + -.5*arma::accu(w % w) + -.5*arma::accu(z % z) +.5* (ndim_z*(N+nit));
  return arma::accu(-U%log((1+exp(tmp))))+lambda*penalty ;
}


// [[Rcpp::export]]
arma::vec deriv_t(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  arma::mat P=1/(1+exp(-(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit))));
  arma::vec penalty(N,1,arma::fill::zeros);
  if(lambda!=-1) penalty=-theta0.col(1);
  return((U%(X-P))*b0.col(1) +lambda*penalty);
}
// [[Rcpp::export]]
arma::vec deriv_b(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  arma::mat P=1/(1+exp(-(theta0*b0.t()-calc_dist(z,w,ndim_z,lambda,C,N,nit))));
  arma::vec penalty(nit,1,arma::fill::zeros);
  if(lambda!=-1) penalty=-b0.col(0);
  return((U%(X-P)).t()*theta0.col(0)+lambda*penalty);
}

// [[Rcpp::export]]
arma::mat deriv_z(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  arma::mat dist=calc_dist(z,w,ndim_z,lambda,C,N,nit)+1e-7;
  arma::mat P=1/(1+exp(-(theta0*b0.t()-dist)));
  arma::mat base=(U%(X-P)%(-1/dist));
  arma::mat tmp(N,ndim_z);
  arma::vec penalty(N,1,arma::fill::zeros);
  for(int s=0;s<ndim_z;s++){
    if(lambda!=-1) penalty=-z.col(s+s+1);
    tmp.col(s)=(base%(z.cols(s+s,s+s+1)*w.cols(s+s,s+s+1).t()))*b0.col(1)+lambda*penalty;
  }
  return(tmp);
}

// [[Rcpp::export]]
arma::mat deriv_w(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  arma::mat dist=calc_dist(z,w,ndim_z,lambda,C,N,nit)+1e-7;
  arma::mat P=1/(1+exp(-(theta0*b0.t()-dist)));
  arma::mat base=(U%(X-P)%(-1/dist));
  arma::mat tmp(nit,ndim_z);
  arma::vec penalty(nit,1,arma::fill::zeros);
  for(int s=0;s<ndim_z;s++){
    if(lambda!=-1) penalty=-w.col(s+s);
    tmp.col(s)=(-base%(z.cols(s+s,s+s+1)*w.cols(s+s,s+s+1).t())).t()*theta0.col(0)+lambda*penalty;
  }
  return(tmp);
}

// [[Rcpp::export]]
arma::vec vec_der(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  arma::vec h_vec((ndim_z+1)*N+(ndim_z+1)*nit);
  h_vec(arma::span(0,N-1))=deriv_t(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  h_vec(arma::span(N,N*(ndim_z+1)-1))=arma::reshape(deriv_z(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit).t(),ndim_z*N,1);
  h_vec(arma::span(N*(ndim_z+1),N*(ndim_z+1)+nit-1))=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  h_vec(arma::span(N*(ndim_z+1)+nit,N*(ndim_z+1)+nit+ndim_z*nit-1))=arma::reshape(deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit).t(),ndim_z*nit,1);
  return(h_vec);
}
// [[Rcpp::export]]
arma::vec vec_par(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C, const arma::mat &X, const arma::mat &U, int N, int nit){
  arma::vec p_vec((ndim_z+1)*N+(ndim_z+1)*nit);
  arma::uvec ind;
  if(ndim_z!=0) ind=arma::regspace<arma::uvec>(0,2,2*ndim_z-2);

  p_vec(arma::span(0,N-1))=theta0.col(1);
  if(ndim_z!=0) p_vec(arma::span(N,N*(ndim_z+1)-1))=arma::reshape((z.cols(ind+1)).t(),ndim_z*N,1);
  p_vec(arma::span(N*(ndim_z+1),N*(ndim_z+1)+nit-1))=b0.col(0);
  if(ndim_z!=0) p_vec(arma::span(N*(ndim_z+1)+nit,N*(ndim_z+1)+nit+ndim_z*nit-1))=arma::reshape((w.cols(ind)).t(),ndim_z*nit,1);
  return(p_vec);
}

// [[Rcpp::export]]
Rcpp::List update_t0(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                      const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=2000){
  arma::vec h=deriv_t(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat theta1= theta0;
  arma::vec step(N);

  for(int p=0; p<N; p++){
    step[p]=step0;
    theta1.col(1)[p]=theta0.col(1)[p]+step[p]*h[p];
    while(logl_p(theta0.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) > logl_p(theta1.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) && step[p]>1e-7){
      step[p]=step[p]*.5 ;
      theta1.col(1)[p]=theta0.col(1)[p]+step[p]*h[p];
    }
  }
  return(Rcpp::List::create(Rcpp::Named("par") = theta1,
                            Rcpp::Named("step") = step));
}

// [[Rcpp::export]]
arma::mat update_t(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                   const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=200){
  arma::vec h=deriv_t(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat theta1= theta0;
  double step=step0;
  for(int p=0; p<N; p++){
    step=step0;
    theta1.col(1)[p]=theta0.col(1)[p]+step*h[p];
    while(logl_p(theta0.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) > logl_p(theta1.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) && step>1e-7){
      step=step*.5;
      theta1.col(1)[p]=theta0.col(1)[p]+step*h[p];
    }
  }
  return(theta1);
}

// [[Rcpp::export]]
Rcpp::List update_b0(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                     const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=500){
  arma::vec h=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat b1= b0;
  arma::vec step(nit);

  for(int i=0; i<nit; i++){
    step[i]=step0;
    b1.col(0)[i]=b0.col(0)[i]+step[i]*h[i];
    while(logl_i(theta0,b0.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) > logl_i(theta0,b1.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) && step[i]>1e-7){
      step[i]=step[i]*.5 ;
      b1.col(0)[i]=b0.col(0)[i]+step[i]*h[i];
    }
  }
  return(Rcpp::List::create(Rcpp::Named("par") = b1,
                            Rcpp::Named("step") = step));
}

// [[Rcpp::export]]
arma::mat update_b(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                   const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=100){
  arma::vec h=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat b1= b0;
  double step=step0;

  for(int i=0; i<nit; i++){
    step=step0;
    b1.col(0)[i]=b0.col(0)[i]+step*h[i];
    while(logl_i(theta0,b0.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) > logl_i(theta0,b1.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1)&& step>1e-7){
      step=step*.5 ;
      b1.col(0)[i]=b0.col(0)[i]+step*h[i];
    }
  }
  return(b1);
}

// [[Rcpp::export]]
Rcpp::List update_z0(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                     const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=1000){
  arma::mat h=deriv_z(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat z1= z;

  arma::vec step(N);

  for(int p=0; p<N; p++){
    step[p]=step0;
    for(int s=0;s<ndim_z;s++)
      z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step[p]*h.col(s)[p];

    while(logl_p(theta0.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) > logl_p(theta0.row(p),b0,z1.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit)&& step[p]>1e-7){
      step[p]=step[p]*.5 ;
      for(int s=0;s<ndim_z;s++)
        z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step[p]*h.col(s)[p];
    }
  }
  return(Rcpp::List::create(Rcpp::Named("par1") = z1,
                            Rcpp::Named("step") = step));
}

//[[Rcpp::export]]
arma::mat update_z(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                   const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=100){
  arma::mat h=deriv_z(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat z1= z;

  double step=step0;
  for(int p=0; p<N; p++){
    step=step0;
    for(int s=0;s<ndim_z;s++)
      z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step*h.col(s)[p];
    while(logl_p(theta0.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) > logl_p(theta0.row(p),b0,z1.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) && step>1e-7){
      step=step*.5 ;

      for(int s=0;s<ndim_z;s++)
        z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step*h.col(s)[p];
    }
  }
  return(z1);
}

// [[Rcpp::export]]
Rcpp::List update_w0(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                     const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=1000){
  arma::mat h=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat w1= w;
  arma::vec step(nit);

  for(int s1=0;s1<(ndim_z-1);s1++)
  for(int s2=0;s2<(ndim_z-1);s2++)
    if(s1>=s2) h.col(s1)[s2]=0;

  for(int i=0; i<nit; i++){
    step[i]=step0;
    for(int s=0;s<ndim_z;s++)
       w1.col(s+s)[i]=w.col(s+s)[i]+step[i]*h.col(s)[i];

    while(logl_i(theta0,b0.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) > logl_i(theta0,b0.row(i),z,w1.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) && step[i]>1e-7){
      step[i]=step[i]*.5 ;
      for(int s=0;s<ndim_z;s++)
        w1.col(s+s)[i]=w.col(s+s)[i]+step[i]*h.col(s)[i];
    }
  }
  return(Rcpp::List::create(Rcpp::Named("par1") = w1,
                                Rcpp::Named("step") = step));
}


// [[Rcpp::export]]
arma::mat update_w(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                   const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=100){
  arma::mat h=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat w1= w;
  double step=step0;

  for(int s1=0;s1<(ndim_z-1);s1++)
    for(int s2=0;s2<(ndim_z-1);s2++)
      if(s1>=s2) h.col(s1)[s2]=0;

  for(int i=0; i<nit; i++){
    step=step0;
    for(int s=0;s<ndim_z;s++)
      w1.col(s+s)[i]=w.col(s+s)[i]+step*h.col(s)[i];

    while(logl_i(theta0,b0.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) > logl_i(theta0,b0.row(i),z,w1.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) && step>1e-7){
      step=step*.5 ;
      for(int s=0;s<ndim_z;s++)
        w1.col(s+s)[i]=w.col(s+s)[i]+step*h.col(s)[i];
    }
  }
  return(w1);
}


// [[Rcpp::export]]
Rcpp::List update_w0_ord(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                         const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, const arma::ivec &nc, double step0=1000){
//J is matrix of dimensions nit0 (actual nit) * nit (number of variables nit>nit0)
  arma::uvec ind;
  if(ndim_z!=0) ind=arma::regspace<arma::uvec>(0,2,2*ndim_z-1);
  else ind=arma::regspace<arma::uvec>(0,2,0);

  arma::mat h=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  if(ndim_z!=0) h=h+lambda*w.cols(ind);  //take penalties out

  arma::mat h0=J*h;

  for(int s1=0;s1<(ndim_z-1);s1++)
    for(int s2=0;s2<(ndim_z-1);s2++)
      if(s1>=s2) h0.col(s1)[s2]=0;

  arma::mat w1= w;
  arma::vec step(nit0);
  int position0=0;

      for(int i=0; i<nit0; i++){
        if(i>0) position0=arma::accu(nc.rows(0,i-1)-1);
        step[i]=step0;
        for(int s=0;s<ndim_z;s++){
          h0.col(s)[i] = h0.col(s)[i]-lambda*w.col(s+s)[position0];
          for(int c=0;c<(nc[i]-1);c++){
            if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step[i]*h0.col(s)[i];
            if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
          }}
        while(logl_i_ord(theta0,b0.rows(position0,position0+nc[i]-2),z,w.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) > logl_i_ord(theta0,b0.rows(position0,position0+nc[i]-2),z,w1.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) && step[i]>1e-7){
          step[i]=step[i]*.5 ;
          for(int s=0;s<ndim_z;s++)
            for(int c=0;c<(nc[i]-1);c++){
              if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step[i]*h0.col(s)[i];
              if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
            }

        }
      }
      return(Rcpp::List::create(Rcpp::Named("par1") = w1,
                                Rcpp::Named("step") = step));
}


// [[Rcpp::export]]
arma::mat update_w_ord(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                       const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, const arma::ivec &nc, double step0=1000){
    //J is matrix of dimensions nit0 (actual nit) * nit (number of variables nit>nit0)
    arma::uvec ind;
    if(ndim_z!=0) ind=arma::regspace<arma::uvec>(0,2,2*ndim_z-1);
    else ind=arma::regspace<arma::uvec>(0,2,0);

    arma::mat h=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
    if(ndim_z!=0) h=h+lambda*w.cols(ind);  //take penalties out

    double step=step0;
    arma::mat h0=J*h;


    for(int s1=0;s1<(ndim_z-1);s1++)
      for(int s2=0;s2<(ndim_z-1);s2++)
        if(s1>=s2) h0.col(s1)[s2]=0;

    arma::mat w1= w;
    int position0=0;

    for(int i=0; i<nit0; i++){
      if(i>0) position0=arma::accu(nc.rows(0,i-1)-1);
      step=step0;
      for(int s=0;s<ndim_z;s++){
        h0.col(s)[i]=h0.col(s)[i]-lambda*w.col(s+s)[position0];
        for(int c=0;c<(nc[i]-1);c++){
          if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step*h0.col(s)[i];
          if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
        }}
      while(logl_i_ord(theta0,b0.rows(position0,position0+nc[i]-2),z,w.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) > logl_i_ord(theta0,b0.rows(position0,position0+nc[i]-2),z,w1.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) && step>1e-7){
          step=step*.5 ;
          for(int s=0;s<ndim_z;s++)
            for(int c=0;c<(nc[i]-1);c++){
              if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step*h0.col(s)[i];
              if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
            }

        }
    }
    return(w1);
  }


// [[Rcpp::export]]
Rcpp::List update_item0(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                        const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=1000){
  arma::mat hw=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat hb=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat b1= b0;
  arma::mat w1= w;
  int ndim=ndim_z;
  if(ndim_z==0) ndim=1;
  arma::mat tmp_i(nit,ndim*2+2);
  arma::vec step(nit);

  for(int s1=0;s1<(ndim_z-1);s1++)
    for(int s2=0;s2<(ndim_z-1);s2++)
      if(s1>=s2) hw.col(s1)[s2]=0;

  for(int i=0; i<nit; i++){
    step[i]=step0;
    for(int s=0;s<ndim_z;s++) w1.col(s+s)[i]=w.col(s+s)[i]+step[i]*hw.col(s)[i];
    b1.col(0)[i]=b0.col(0)[i]+step[i]*hb[i];
    if(C!=0){
      tmp_i.row(i)=project_item(arma::join_rows(b1.row(i),w1.row(i)),ndim_z,C,arma::mean(b0.col(1)));
      b1.col(0)=tmp_i.col(0);
      for(int s=0;s<ndim_z;s++) w1.col(s+s)=tmp_i.col(s+s+2);
    }

    while(logl_i(theta0,b0.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) > logl_i(theta0,b1.row(i),z,w1.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) && step[i]>1e-7){
      step[i]=step[i]*.5;
      b1.col(0)[i]=b0.col(0)[i]+step[i]*hb[i];
      for(int s=0;s<ndim_z;s++) w1.col(s+s)[i]=w.col(s+s)[i]+step[i]*hw.col(s)[i];
      if(C!=0){
        tmp_i.row(i)=project_item(arma::join_rows(b1.row(i),w1.row(i)),ndim_z,C,arma::mean(b0.col(1)));
        b1.col(0)=tmp_i.col(0);
        for(int s=0;s<ndim_z;s++) w1.col(s+s)=tmp_i.col(s+s+2);
      }
    }
  }
  return(Rcpp::List::create(Rcpp::Named("par1") = b1,
                            Rcpp::Named("par2") = w1,
                            Rcpp::Named("step") = step));
}




// [[Rcpp::export]]
arma::mat update_item(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                      const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=1000){
  arma::mat hw=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat hb=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat b1= b0;
  arma::mat w1= w;
  int ndim=ndim_z;
  if(ndim_z==0) ndim=1;
  arma::mat tmp_i(nit,ndim*2+2);
  double step=step0;

  for(int s1=0;s1<(ndim_z-1);s1++)
    for(int s2=0;s2<(ndim_z-1);s2++)
      if(s1>=s2) hw.col(s1)[s2]=0;

  for(int i=0; i<nit; i++){
    step=step0;
    for(int s=0;s<ndim_z;s++) w1.col(s+s)[i]=w.col(s+s)[i]+step*hw.col(s)[i];
    b1.col(0)[i]=b0.col(0)[i]+step*hb[i];
    if(C!=0){
      tmp_i.row(i)=project_item(arma::join_rows(b1.row(i),w1.row(i)),ndim_z,C,arma::mean(b0.col(1)));
      b1.col(0)=tmp_i.col(0);
      for(int s=0;s<ndim_z;s++) w1.col(s+s)=tmp_i.col(s+s+2);
    }

    while(logl_i(theta0,b0.row(i),z,w.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) > logl_i(theta0,b1.row(i),z,w1.row(i),ndim_z,lambda,C,X.col(i),U.col(i),J,J0,N,1,1) && step>1e-7){
      step=step*.5;
      b1.col(0)[i]=b0.col(0)[i]+step*hb[i];
      for(int s=0;s<ndim_z;s++) w1.col(s+s)[i]=w.col(s+s)[i]+step*hw.col(s)[i];
      if(C!=0){
        tmp_i.row(i)=project_item(arma::join_rows(b1.row(i),w1.row(i)),ndim_z,C,arma::mean(b0.col(1)));
        b1.col(0)=tmp_i.col(0);
        for(int s=0;s<ndim_z;s++) w1.col(s+s)=tmp_i.col(s+s+2);
      }
    }
  }
  return(arma::join_rows(b1,w1));
}

// [[Rcpp::export]]
Rcpp::List update_item0_ord(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                            const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, const arma::ivec &nc, double step0=1000){
  arma::mat hw=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat hb=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat b1= b0;
  arma::mat w1= w;

  arma::mat hw0=J*hw;
  int ndim=ndim_z;
  if(ndim_z==0) ndim=1;
  arma::mat tmp_i(nit0,ndim*2+2*(nc.max()-1));
  arma::vec step(nit0);
  int position0=0;

  for(int s1=0;s1<(ndim_z-1);s1++)
    for(int s2=0;s2<(ndim_z-1);s2++)
      if(s1>=s2) hw0.col(s1)[s2]=0;

  for(int i=0; i<nit0; i++){
    if(i>0) position0=arma::accu(nc.rows(0,i-1)-1);
    step[i]=step0;
    for(int c=0;c<(nc[i]-1);c++){
      for(int s=0;s<ndim_z;s++){
        if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step[i]*hw0.col(s)[i];
        if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
      }
      b1.col(0)[position0+c]=b0.col(0)[position0+c]+step[i]*hb[position0+c];
    }
    if(C!=0){
      tmp_i.row(i).head((nc[i]-1)*2+2*ndim_z)=project_item_ord(arma::join_rows(arma::reshape(arma::trans(b1.rows(position0,position0+nc[i]-2)),1,(nc[i]-1)*2),w1.row(position0)),ndim_z,C,nc[i],arma::mean(b0.col(0)));
      for(int c=0;c<(nc[i]-1);c++){
        b1.col(0)[position0+c]=tmp_i.col(c*2)[i];
        for(int s=0;s<ndim_z;s++) w1.col(s+s)[position0+c]=tmp_i.col(s+s+2*(nc[i]-1))[i];
      }
    }
    while(logl(theta0,b0.rows(position0,position0+nc[i]-2),z,w.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) > logl(theta0,b1.rows(position0,position0+nc[i]-2),z,w1.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) && step[i]>1e-7){
      step[i]=step[i]*.5;
      for(int c=0;c<(nc[i]-1);c++){
        for(int s=0;s<ndim_z;s++){
          if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step[i]*hw0.col(s)[i];
          if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
        }
        b1.col(0)[position0+c]=b0.col(0)[position0+c]+step[i]*hb[position0+c];
      }
      if(C!=0){
        tmp_i.row(i).head((nc[i]-1)*2+2*ndim_z)=project_item_ord(arma::join_rows(arma::reshape(arma::trans(b1.rows(position0,position0+nc[i]-2)),1,(nc[i]-1)*2),w1.row(position0)),ndim_z,C,nc[i],arma::mean(b0.col(0)));
        for(int c=0;c<(nc[i]-1);c++){
          b1.col(0)[position0+c]=tmp_i.col(c*2)[i];
          for(int s=0;s<ndim_z;s++) w1.col(s+s)[position0+c]=tmp_i.col(s+s+2*(nc[i]-1))[i];
        }
      }
    }
  }
  return(Rcpp::List::create(Rcpp::Named("par1") = b1,
                            Rcpp::Named("par2") = w1,
                            Rcpp::Named("step") = step));
}

// [[Rcpp::export]]
arma::mat update_item_ord(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                          const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, const arma::ivec &nc, double step0=1000){
  arma::mat hw=deriv_w(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat hb=deriv_b(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat b1= b0;
  arma::mat w1= w;

  arma::mat hw0=J*hw;
  int ndim=ndim_z;
  if(ndim_z==0) ndim=1;
  arma::mat tmp_i(nit0,ndim*2+2*(nc.max()-1));
  double step=step0;
  int position0=0;

  for(int s1=0;s1<(ndim_z-1);s1++)
    for(int s2=0;s2<(ndim_z-1);s2++)
      if(s1>=s2) hw0.col(s1)[s2]=0;

  for(int i=0; i<nit0; i++){
    if(i>0) position0=arma::accu(nc.rows(0,i-1)-1);
    step=step0;
    for(int c=0;c<(nc[i]-1);c++){
      for(int s=0;s<ndim_z;s++){
        if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step*hw0.col(s)[i];
        if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
      }
      b1.col(0)[position0+c]=b0.col(0)[position0+c]+step*hb[position0+c];
    }
    if(C!=0){
      tmp_i.row(i).head((nc[i]-1)*2+2*ndim_z)=project_item_ord(arma::join_rows(arma::reshape(arma::trans(b1.rows(position0,position0+nc[i]-2)),1,(nc[i]-1)*2),w1.row(position0)),ndim_z,C,nc[i],arma::mean(b0.col(0)));
      for(int c=0;c<(nc[i]-1);c++){
        b1.col(0)[position0+c]=tmp_i.col(c*2)[i];
        for(int s=0;s<ndim_z;s++) w1.col(s+s)[position0+c]=tmp_i.col(s+s+2*(nc[i]-1))[i];
      }
    }
    while(logl(theta0,b0.rows(position0,position0+nc[i]-2),z,w.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) > logl(theta0,b1.rows(position0,position0+nc[i]-2),z,w1.rows(position0,position0+nc[i]-2),ndim_z,lambda,C,X.cols(position0,position0+nc[i]-2),U.cols(position0,position0+nc[i]-2),J,J0,N,nc[i]-1,1) && step>1e-7){
      step=step*.5;
      for(int c=0;c<(nc[i]-1);c++){
        for(int s=0;s<ndim_z;s++){
          if(c==0) w1(position0,s+s)=w.col(s+s)[position0]+step*hw0.col(s)[i];
          if(c>0) w1(position0+c,s+s)=w1(position0,s+s);
        }
        b1.col(0)[position0+c]=b0.col(0)[position0+c]+step*hb[position0+c];
      }
      if(C!=0){
        tmp_i.row(i).head((nc[i]-1)*2+2*ndim_z)=project_item_ord(arma::join_rows(arma::reshape(arma::trans(b1.rows(position0,position0+nc[i]-2)),1,(nc[i]-1)*2),w1.row(position0)),ndim_z,C,nc[i],arma::mean(b0.col(0)));
        for(int c=0;c<(nc[i]-1);c++){
          b1.col(0)[position0+c]=tmp_i.col(c*2)[i];
          for(int s=0;s<ndim_z;s++) w1.col(s+s)[position0+c]=tmp_i.col(s+s+2*(nc[i]-1))[i];
        }
      }
    }
  }
  return(arma::join_rows(b1,w1));
}

// [[Rcpp::export]]
Rcpp::List update_pers0(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                        const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=1000){
  arma::mat ht=deriv_t(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat hz=deriv_z(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat theta1= theta0;
  arma::mat z1= z;
  int ndim=ndim_z;
  if(ndim_z==0) ndim=1;
  arma::mat tmp_p(N,ndim*2+2);
  arma::vec step(N);

  for(int p=0; p<N; p++){
    step[p]=step0;
    theta1.col(1)[p]=theta0.col(1)[p]+step[p]*ht[p];
    for(int s=0;s<ndim_z;s++) z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step[p]*hz.col(s)[p];
    if(C!=0){
      tmp_p.row(p)=project_pers(arma::join_rows(theta1.row(p),z1.row(p)),ndim_z,C);
      theta1.col(1)=tmp_p.col(1);
      for(int s=0;s<ndim_z;s++) z1.col(s+s+1)=tmp_p.col(s+s+3);
    }
    while(logl_p(theta0.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) > logl_p(theta1.row(p),b0,z1.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit)&& step[p]>1e-7){
      step[p]=step[p]*.5 ;
      theta1.col(1)[p]=theta0.col(1)[p]+step[p]*ht[p];
      for(int s=0;s<ndim_z;s++) z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step[p]*hz.col(s)[p];
      if(C!=0){
        tmp_p.row(p)=project_pers(arma::join_rows(theta1.row(p),z1.row(p)),ndim_z,C);
        theta1.col(1)=tmp_p.col(1);
        for(int s=0;s<ndim_z;s++) z1.col(s+s+1)=tmp_p.col(s+s+3);
      }
    }}
  return(Rcpp::List::create(Rcpp::Named("par1") = theta1,
                            Rcpp::Named("par2") = z1,
                            Rcpp::Named("step") = step));
}

// [[Rcpp::export]]
arma::mat update_pers(const arma::mat &theta0, const arma::mat &b0, const arma::mat &z, const arma::mat &w, int ndim_z, double lambda, double C,
                      const arma::mat &X, const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, double step0=1000){
  arma::mat ht=deriv_t(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat hz=deriv_z(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit);
  arma::mat theta1= theta0;
  arma::mat z1= z;
  int ndim=ndim_z;
  if(ndim_z==0) ndim=1;
  arma::mat tmp_p(N,ndim*2+2);
  double step=step0;

  for(int p=0; p<N; p++){
    step=step0;
    theta1.col(1)[p]=theta0.col(1)[p]+step*ht[p];
    for(int s=0;s<ndim_z;s++) z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step*hz.col(s)[p];
    if(C!=0){
      tmp_p.row(p)=project_pers(arma::join_rows(theta1.row(p),z1.row(p)),ndim_z,C);
      theta1.col(1)=tmp_p.col(1);
      for(int s=0;s<ndim_z;s++) z1.col(s+s+1)=tmp_p.col(s+s+3);
    }
    while(logl_p(theta0.row(p),b0,z.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit) > logl_p(theta1.row(p),b0,z1.row(p),w,ndim_z,lambda,C,X.row(p), U.row(p),J,J0,1,nit,nit)&& step>1e-7){
      step=step*.5 ;
      theta1.col(1)[p]=theta0.col(1)[p]+step*ht[p];
      for(int s=0;s<ndim_z;s++) z1.col(s+s+1)[p]=z.col(s+s+1)[p]+step*hz.col(s)[p];
      if(C!=0){
        tmp_p.row(p)=project_pers(arma::join_rows(theta1.row(p),z1.row(p)),ndim_z,C);
        theta1.col(1)=tmp_p.col(1);
        for(int s=0;s<ndim_z;s++) z1.col(s+s+1)=tmp_p.col(s+s+3);
      }
    }}
  return(arma::join_rows(theta1,z1));
}

// [[Rcpp::export]]
Rcpp::List fitModel(const arma::mat &theta_start, const arma::mat &b_start, const arma::mat &z_start,
                    const arma::mat &w_start, int ndim_z, double lambda, double C, const arma::mat &X,
                    const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, const arma::ivec &nc,
                    double tol=1e-5, bool silent=false){
  arma::mat hw_out(nit0,ndim_z);
  arma::mat b0=b_start;
  arma::mat theta0=theta_start;
  arma::mat w=w_start;
  arma::mat z=z_start;
  bool GRM=false;
  if(nit!=nit0) GRM=true;
  double logl0=logl(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);

  Rcpp::List tmp_b=update_b0(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
  arma::mat b1=tmp_b[0];
  arma::vec step_b0 = tmp_b[1];
  double step_b=mean(step_b0);

  Rcpp::List tmp_t=update_t0(theta0,b1,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
  arma::mat theta1=tmp_t[0];
  arma::vec step_t0 = tmp_t[1];
  double step_t=mean(step_t0);

  Rcpp::List tmp_z=update_z0(theta1,b1,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
  arma::mat z1=tmp_z[0];
  arma::vec step_z0 = tmp_z[1];
  double step_z=mean(step_z0);
  Rcpp::List tmp_w;

  if(GRM==false) tmp_w=update_w0(theta1,b1,z1,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
  else tmp_w=update_w0_ord(theta1,b1,z1,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,nc);
  arma::mat w1=tmp_w[0];
  arma::vec step_w0 = tmp_w[1];
  double step_w=mean(step_w0);
  double logl1=logl(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);

  int iter=1;
  if(silent==false){
    Rcpp::Rcout <<"Penalized Latent Space IRT Estimation ";
    if(GRM==false) Rcpp::Rcout <<"for Dichotomous Data.";
    if(GRM==true) Rcpp::Rcout << "for Ordinal Data.";
    Rcpp::Rcout<<"\n----------------------------------------------------------\n";

    Rcpp::Rcout <<"it."<<" | "<<
      "logl. diff" << " | "<<
        "relatv diff"<< " | "<<
          "gradient t"<< " | "<<
            "gradient b"<< " | "<<
              "gradient z"<< " | "<<
                "gardient w"<< " | "<<
                  "max change\n";
  };
  while((logl1-logl0)>tol){
    iter=iter+1;
    b0=b1;
    theta0=theta1;
    w=w1;
    z=z1;

    if((iter%100)==0){

      tmp_b=update_b0(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
      arma::mat b1X=tmp_b[0];
      b1=b1X;
      arma::vec step_b0 = tmp_b[1];
      step_b=mean(step_b0);

      tmp_t=update_t0(theta0,b1,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
      arma::mat theta1X=tmp_t[0];
      theta1=theta1X;
      arma::vec step_t0 = tmp_t[1];
      step_t=mean(step_t0);

      tmp_z=update_z0(theta1,b1,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
      arma::mat z1X=tmp_z[0];
      z1=z1X;
      arma::vec step_z0 = tmp_z[1];
      step_z=mean(step_z0);

      if(GRM==false){
        tmp_w=update_w0(theta1,b1,z1,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
        arma::mat w1X=tmp_w[0];
        w1=w1X;
        arma::vec step_w0 = tmp_w[1];
        step_w=mean(step_w0);
      } else{
        tmp_w=update_w0_ord(theta1,b1,z1,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,nc);
        arma::mat w1X=tmp_w[0];
        w1=w1X;
        arma::vec step_w0 = tmp_w[1];
        step_w=mean(step_w0);
      }
    } else{
      theta1=update_t(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,step_t);
      b1=update_b(theta1,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,step_b);
      z1=update_z(theta1,b1,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,step_z);
      if(GRM==false) w1=update_w(theta1,b1,z1,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,step_w);
      else w1=update_w_ord(theta1,b1,z1,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,nc,step_w);
    }

    logl0=logl1;
    logl1=logl(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);

    if(silent==false){
        for(int s1=0;s1<(ndim_z-1);s1++)
        for(int s2=0;s2<(ndim_z-1);s2++)
          if(s1>=s2) hw_out.col(s1)[s2]=0;

      Rcpp::Rcout<< "\r";
      if(iter<100) Rcpp::Rcout <<iter<<"  | ";
      if(iter>=100) Rcpp::Rcout <<iter<<" | ";
      Rcpp::Rcout<<std::fixed<<std::setprecision(8)<<
        logl1-logl0 << " | "<<
          (logl1-logl0)/logl0<< " | "<<
            arma::sqrt(pow(deriv_t(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit),2)).max()<< " | "<<
              arma::sqrt(pow(deriv_b(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit),2)).max()<< " | ";
              if(ndim_z!=0){
                if(GRM==true) hw_out=J*(deriv_w(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit));
                else hw_out=deriv_w(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit);
                Rcpp::Rcout << std::fixed<<std::setprecision(8)<<arma::sqrt(pow(deriv_z(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit),2)).max()<< " | ";
                Rcpp::Rcout<<arma::sqrt(pow(hw_out,2)).max()<< " | ";
              } else Rcpp::Rcout<<"     0     |"<< "     0      | ";
              Rcpp::Rcout <<std::fixed<<std::setprecision(8)<<arma::sqrt(pow(vec_par(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit)-vec_par(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit),2)).max()<<"                                  ";
    }
  }

  if(silent==false){
    Rcpp::Rcout <<"\n----------------";
    Rcpp::Rcout <<"\nConverged" << "\n";
    Rcpp::Rcout <<"Final tolerance: "<< std::setprecision(6)<<logl1-logl0 << "\n";
    Rcpp::Rcout <<"Log-Likelhood: "<< logl1 << "\n";
  }
  arma::vec final_steps(4);
  final_steps(0)=step_t;
  final_steps(1)=step_b;
  final_steps(2)=step_z;
  final_steps(3)=step_w;

  return Rcpp::List::create(Rcpp::Named("theta") = theta1,
                            Rcpp::Named("b") = b1,
                            Rcpp::Named("z") = z1,
                            Rcpp::Named("w") = w1,
                            Rcpp::Named("steps") = final_steps,
                            Rcpp::Named("logLik") = logl1);
}


// [[Rcpp::export]]
Rcpp::List fitModel_C(const arma::mat &theta_start, const arma::mat &b_start, const arma::mat &z_start,
                      const arma::mat &w_start, int ndim_z, double lambda, double C, const arma::mat &X,
                      const arma::mat &U, const arma::mat &J, const arma::mat &J0, int N, int nit, int nit0, const arma::ivec &nc, double tol=1e-5, bool silent=false){
  arma::mat hw_out(nit0,ndim_z);
  arma::mat b0=b_start;
  arma::mat theta0=theta_start;
  arma::mat w=w_start;
  arma::mat z=z_start;
  arma::mat new_p(N,ndim_z*2+2);
  arma::mat new_i(nit,ndim_z*2+2);
  bool GRM=false;
  if(nit!=nit0) GRM=true;

  double logl0=logl(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);

  Rcpp::List tmp_item;
  if(GRM==false) tmp_item=update_item0(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
  else tmp_item=update_item0_ord(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,nc);
  arma::mat b1=tmp_item[0];
  arma::mat w1=tmp_item[1];
  arma::vec step_item0 = tmp_item[2];
  double step_item=mean(step_item0);
  Rcpp::List tmp_pers=update_pers0(theta0,b1,z,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
  arma::mat theta1=tmp_pers[0];
  arma::mat z1=tmp_pers[1];
  arma::vec step_pers0 = tmp_pers[2];
  double step_pers=mean(step_pers0);
  double logl1=logl(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);

  int iter=1;
  if(silent==false){
    Rcpp::Rcout <<"Constrained Latent Space IRT Estimation ";
    if(GRM==false) Rcpp::Rcout <<"for Dichotomous Data.";
    if(GRM==true) Rcpp::Rcout << "for Ordinal Data.";
    Rcpp::Rcout<<"\n----------------------------------------------------------\n";

    Rcpp::Rcout <<"it."<<" | "<<
      "logL diff" << " | "<<
        "relativ diff"<< " | "<<
          "gradient t"<< " | "<<
            "gradient b"<< " | "<<
              "gradient z"<< " | "<<
                "gardient w"<< " | "<<
                  "max change\n";
  };
  while((logl1-logl0)>tol){
    iter=iter+1;
    b0=b1;
    theta0=theta1;
    w=w1;
    z=z1;

    if((iter%100)==0){
      if(GRM==false) tmp_item=update_item0(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
      else tmp_item=update_item0_ord(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,nc);
      arma::mat b1X=tmp_item[0];
      b1=b1X;
      arma::mat w1X=tmp_item[1];
      w1=w1X;
      arma::vec step_item0 = tmp_item[2];
      step_item=mean(step_item0);

      tmp_pers=update_pers0(theta0,b1,z,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
      arma::mat theta1X=tmp_pers[0];
      theta1=theta1X;
      arma::mat z1X=tmp_pers[1];
      z1=z1X;
      arma::vec step_pers0 = tmp_pers[2];
      step_pers=mean(step_pers0);
    } else{
      if(GRM==false) new_i=update_item(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,step_item);
      else new_i=update_item_ord(theta0,b0,z,w,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,nc,step_item);
      b1.col(0)=new_i.col(0);
      for(int s=0;s<ndim_z;s++) w1.col(s+s)=new_i.col(s+s+2);

      new_p=update_pers(theta0,b1,z,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0,step_pers);
      theta1.col(1)=new_p.col(1);
      for(int s=0;s<ndim_z;s++) z1.col(s+s+1)=new_p.col(s+s+3);

    }

    logl0=logl1;
    logl1=logl(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,J,J0,N,nit,nit0);
    if(silent==false){

      for(int s1=0;s1<(ndim_z-1);s1++)
        for(int s2=0;s2<(ndim_z-1);s2++)
          if(s1>=s2) hw_out.col(s1)[s2]=0;

      Rcpp::Rcout<< "\r";
      if(iter<100) Rcpp::Rcout <<iter<<"  | ";
      if(iter>=100) Rcpp::Rcout <<iter<<" | ";
      Rcpp::Rcout<<std::fixed<<std::setprecision(8)<<
        logl1-logl0 << " | "<<
          (logl1-logl0)/logl0<< " | "<<
            arma::sqrt(pow(deriv_t(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit),2)).max()<< " | "<<
              arma::sqrt(pow(deriv_b(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit),2)).max()<< " | ";
              if(ndim_z!=0){
                if(GRM==true) hw_out=J*(deriv_w(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit));
                else hw_out=deriv_w(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit);
                Rcpp::Rcout << std::fixed<<std::setprecision(8)<<arma::sqrt(pow(deriv_z(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit),2)).max()<< " | ";
                Rcpp::Rcout<<arma::sqrt(pow(hw_out,2)).max()<< " | ";
              } else Rcpp::Rcout<<"     0     |"<< "     0      | ";
              Rcpp::Rcout <<std::fixed<<std::setprecision(8)<<arma::sqrt(pow(vec_par(theta1,b1,z1,w1,ndim_z,lambda,C,X,U,N,nit)-vec_par(theta0,b0,z,w,ndim_z,lambda,C,X,U,N,nit),2)).max()<<"                                  ";
    }
  }

  if(silent==false){
    Rcpp::Rcout <<"\n----------------";
    Rcpp::Rcout <<"\nConverged" << "\n";
    Rcpp::Rcout <<"Final tolerance: "<< std::setprecision(6)<<logl1-logl0 << "\n";
    Rcpp::Rcout <<"Log-Likelhood: "<< logl1 << "\n";
  }
  arma::vec final_steps(2);
  final_steps(0)=step_pers;
  final_steps(1)=step_item;

  return Rcpp::List::create(Rcpp::Named("theta") = theta1,
                            Rcpp::Named("b") = b1,
                            Rcpp::Named("z") = z1,
                            Rcpp::Named("w") = w1,
                            Rcpp::Named("steps") = final_steps,
                            Rcpp::Named("logLik") = logl1);
}

