% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_functions.R
\name{correct_positive_definite}
\alias{correct_positive_definite}
\title{Positive definite matrices}
\usage{
correct_positive_definite(
  covmat,
  correction_val = 0.99,
  correction_limit = 100
)
}
\arguments{
\item{covmat}{A symmetric and numeric matrix. If the covariance matrix
should be corrected, it must have a number of attributes, such as
\code{attr(covmat,"fam_vec")}, \code{attr(covmat,"n_fam")},
\code{attr(covmat,"add_ind")}, \code{attr(covmat,"h2")},
\code{attr(covmat,"genetic_corrmat")}, \code{attr(covmat,"full_corrmat")}
and \code{attr(covmat,"phenotype_names")}. Any covariance matrix
obtained by \code{\link{construct_covmat}}, \code{\link{construct_covmat_single}}
or \code{\link{construct_covmat_multi}} will have these attributes by default.}

\item{correction_val}{A positive number representing the amount by which
\code{genetic_corrmat} and \code{full_corrmat} will be changed, if some
eigenvalues are non-positive. That is, correction_val is the number that will be
multiplied to all off_diagonal entries in \code{genetic_corrmat} and \code{full_corrmat}.
Defaults to 0.99.}

\item{correction_limit}{A positive integer representing the upper limit for the correction
procedure. Defaults to 100.}
}
\value{
If \code{covmat} is a symmetric and numeric matrix and all eigenvalues are
positive, \code{correct_positive_definite} simply returns \code{covmat}. If some
eigenvalues are not positive and \code{correction_val} is a positive number,
\code{correct_positive_definite} tries to convert \code{covmat} into a positive definite
matrix. If \code{covmat} has attributes \code{add_ind}, \code{h2},
\code{genetic_corrmat}, \code{full_corrmat} and \code{phenotype_names},
\code{correct_positive_definite} computes a new covariance matrix using slightly
modified correlation matrices \code{genetic_corrmat} and \code{full_corrmat}.
If the correction is performed successfully, i.e. if the new covariance matrix
is positive definite,the new covariance matrix is returned.
Otherwise, \code{correct_positive_definite} returns the original covariance matrix.
}
\description{
\code{correct_positive_definite} verifies that a given covariance matrix
is indeed positive definite by checking that all eigenvalues are positive.
If the given covariance matrix is not positive definite,
\code{correct_positive_definite} tries to modify the underlying correlation matrices
genetic_corrmat and full_corrmat in order to obtain a positive definite
covariance matrix.
}
\details{
This function can be used to verify that a given covariance matrix
is positive definite. It calculates all eigenvalues in order to
investigate whether they are all positive. This property is necessary
for the covariance matrix to be used as a Gaussian covariance matrix.
It is especially useful to check whether any covariance matrix obtained
by \code{\link{construct_covmat_multi}} is positive definite.
If the given covariance matrix is not positive definite, \code{correct_positive_definite}
tries to modify the underlying correlation matrices (called \code{genetic_corrmat} and
\code{full_corrmat} in \code{\link{construct_covmat}} or \code{\link{construct_covmat_multi}}) by
multiplying all off-diagonal entries in the correlation matrices by a given number.
}
\examples{
ntrait <- 2
genetic_corrmat <- matrix(0.6, ncol = ntrait, nrow = ntrait)
diag(genetic_corrmat) <- 1
full_corrmat <- matrix(-0.25, ncol = ntrait, nrow = ntrait)
diag(full_corrmat) <- 1
h2_vec <- rep(0.6, ntrait)
cov <- construct_covmat(fam_vec = c("m", "f"),
  genetic_corrmat = genetic_corrmat,
  h2 = h2_vec,
  full_corrmat = full_corrmat)
cov
correct_positive_definite(cov)

}
\seealso{
\code{\link{construct_covmat}}, \code{\link{construct_covmat_single}} and
\code{\link{construct_covmat_multi}}.
}
