% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_functions.R
\name{make_matrices_old}
\alias{make_matrices_old}
\title{Build the design and the penalty matrix for models involving penalised splines based on a formula and a data set}
\usage{
make_matrices_old(formula, data, knots = NULL)
}
\arguments{
\item{formula}{right side of a formula as used in \code{mgcv}}

\item{data}{data frame containing the variables in the formula}

\item{knots}{optional list containing user specified knot values to be used for basis construction

For most bases the user simply supplies the \code{knots} to be used, which must match up with the \code{k} value supplied (note that the number of knots is not always just \code{k}).
See \code{mgcv} documentation for more details.}
}
\value{
a list containing the design matrix \code{Z}, a (potentially nested) list of penalty matrices \code{S}, the \code{formula}, the \code{data}, the \code{knots}, and the original \code{mod} object returned by \code{mgcv}.
Note that for tensorproduct smooths, the corresponding list entry is itself a list, containing the d marginal penalty matrices if d is the dimension of the tensor product.
}
\description{
Build the design and the penalty matrix for models involving penalised splines based on a formula and a data set
}
\examples{
data = data.frame(x = runif(100), 
                  y = runif(100),
                  g = factor(rep(1:10, each = 10)))

# unvariate thin plate regression spline
modmat = make_matrices(~ s(x), data)
# univariate P-spline
modmat = make_matrices(~ s(x, bs = "ps"), data)
# adding random intercept
modmat = make_matrices(~ s(g, bs = "re") + s(x, bs = "ps"), data)
# tensorproduct of x and y
modmat = make_matrices(~ s(x) + s(y) + ti(x,y), data)
}
