% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_nvR.R
\name{nvRD_cumulative_response}
\alias{nvRD_cumulative_response}
\title{Cumulative non-visual direct response}
\usage{
nvRD_cumulative_response(
  nvRD,
  Time.vector,
  epoch = "dominant.epoch",
  as.df = FALSE
)
}
\arguments{
\item{nvRD}{Numeric vector containing the non-visual direct response.
See \code{\link{nvRD}}.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct}, \link[hms]{hms},
\link[lubridate]{duration}, or \link[base]{difftime}.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{as.df}{Logical. Should a data frame with be returned? If \code{TRUE}, a data
frame with a single column named \code{nvRD_cumulative} will be returned.
Defaults to \code{FALSE}.}
}
\value{
A numeric value or single column data frame.
}
\description{
This function calculates the cumulative non-visual direct response (nvRD). This is
basically the integral of the nvRD over the provided time period in hours. The
unit of the resulting value thus is "nvRD*h".
}
\examples{
dataset1 <-
  tibble::tibble(
    Id = rep("A", 60 * 24),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(0:(60*24-1)),
    Illuminance = c(rep(0, 60*8), rep(sample(1:1000, 14, replace = TRUE), each = 60), rep(0, 60*2)),
    MEDI = Illuminance * rep(sample(0.5:1.5, 24, replace = TRUE), each = 60)
  ) \%>\%
  dplyr::mutate(
    nvRD = nvRD(MEDI, Illuminance, Datetime)
  ) 
dataset1 \%>\% 
  dplyr::summarise(
    "cumulative nvRD" = nvRD_cumulative_response(nvRD, Datetime)
  )

}
\references{
Amundadottir, M.L. (2016). Light-driven model for identifying
indicators of non-visual health potential in the built environment
[Doctoral dissertation, EPFL]. EPFL infoscience.
\doi{10.5075/epfl-thesis-7146}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
