% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTab.R
\name{TTab}
\alias{TTab}
\title{Truth table}
\usage{
TTab(data, tree, Xs, mtype)
}
\arguments{
\item{data}{A data frame containing input predictors.}

\item{tree}{An object of class \code{logregtree} representing a logic regression tree constructed for a sample.}

\item{Xs}{A vector of predictor names corresponding to columns in \code{data}.}

\item{mtype}{Model type: 1 = classification, 2 = linear regression, 3 = survival regression, 4 = other.}
}
\value{
A matrix \code{mat.truth} of binary predictor values corresponding to the predictions of the logic tree.
Rows correspond to all permutations of predictors included in the tree that yield the "truth" outcome.
}
\description{
Internal function to evaluate the importance of predictor combinations within a logic regression tree.
This function is called by \code{\link{prime.imp}} and is not intended to be used independently.
}
\details{
Generates a matrix of all binary interactions contained in a single sample's logic regression tree.
Only predictors included in the logic regression tree are included in the matrix.
The resulting matrix can be used to evaluate the importance of specific predictor combinations.
}
\references{
Wolf BJ, Hill EG, Slate EH. Logic Forest: an ensemble classifier for discovering logical combinations of binary markers.
Bioinformatics. 2010;26(17):2183-2189. doi:10.1093/bioinformatics/btq354
}
\seealso{
\code{\link{prime.imp}}
}
\author{
Bethany J. Wolf \email{wolfb@musc.edu}
}
\keyword{internal}
