% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prime.imp.R
\name{prime.imp}
\alias{prime.imp}
\title{Extract Prime Variable Interactions from a Logic Regression Tree}
\usage{
prime.imp(tree, data, Xs, mtype)
}
\arguments{
\item{tree}{An object of class \code{"logregtree"}.}

\item{data}{Data frame used to fit the logic forest.}

\item{Xs}{A vector of predictor names corresponding to columns in \code{data}.}

\item{mtype}{Model type (e.g., classification, linear regression, survival regression).}
}
\value{
An object of class \code{"primeImp"} with the following elements:
\item{vec.primes}{Character vector of variable interactions in logical format.}
\item{tmp.mat}{Matrix of all binary interactions contained in the tree.}
\item{vec.pimpvars}{Sorted vector of column indices in \code{data} for important predictors.}
\item{list.pimps}{List of vectors, each containing indices of predictors involved in each interaction.}
}
\description{
Internal function called by \code{\link{pimp.import}}.
It is not intended to be used independently.
Generates a list of all variables and variable interactions identified by a specific
logic regression tree within a logic forest or LBoost model.
}
\details{
This function constructs all possible interactions of the predictors contained in
the tree, identifies those that contribute to a positive outcome ("prime interactions"),
and returns information about which variables and interactions are included in each.
}
\author{
Bethany Wolf \email{wolfb@musc.edu}
}
\keyword{internal}
