% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MATESmain.R
\name{MATES}
\alias{MATES}
\title{MATES test statistic with two samples (recommended for general use)}
\usage{
MATES(
  X,
  Y,
  S = 4,
  dt = "manhattan",
  gh = "NNG",
  wt = "kernel",
  pow = 0.8,
  perm = NULL
)
}
\arguments{
\item{X}{A numeric matrix of size m x d}

\item{Y}{A numeric matrix of size n x d}

\item{S}{An integer representing the number of moments to use}

\item{dt}{A character string indicating the distance metric to use
("manhattan" or "Lp")}

\item{gh}{A character string indicating the graph type to use
("NNG", "MST", or "rNNG")}

\item{wt}{A character string indicating the weight function to use
("kernel", "rank", "distance", or "plain")}

\item{pow}{A numeric representing the number of neighbors to use for graph, if
pow = 0, then use default value 10; otherwise use round(N^pow)}

\item{perm}{An integer indicating the number of permutation (default is NULL,
which uses closed form)}
}
\value{
A list with the MATES test statistic (test.stat) and p-value (pval)
}
\description{
This function takes two data matrices (m x d and n x d) and other parameters
to compute the MATES test statistic. It only implements the same distance,
graph, and weight options across all views. For other combinations, please
compute the corresponding view matrices (R_list) and use the MATES_stat function
directly.
}
\examples{
# Generate two-sample data from different distributions
set.seed(123)
X <- matrix(rnorm(50, mean = 0), ncol = 5)  # 10 samples from N(0,1)
Y <- matrix(rnorm(50, mean = 0.5), ncol = 5)  # 10 samples from N(0.5,1)

# Perform MATES test
result <- MATES(X, Y, S = 4, dt = "manhattan", gh = "NNG", wt = "kernel", pow = 0.8)
print(result$test.stat)
print(result$pval)
}
