% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compileModel.R
\name{compileModel}
\alias{compileModel}
\title{Function to translate and compile MCSim model specification text}
\usage{
compileModel(
  model_file,
  c_file,
  dll_name,
  dll_file,
  source_file = model_file,
  hash_file = NULL,
  verbose_output = FALSE
)
}
\arguments{
\item{model_file}{Name of an MCSim model specification file.}

\item{c_file}{Name of a C source code file to be created by compiling the MCSim model specification file.}

\item{dll_name}{Name of a DLL or SO file without the extension (".dll" or ".so").}

\item{dll_file}{Name of the same DLL or SO file with the appropriate extension (".dll" or ".so").}

\item{source_file}{Name of the original source file to use for hash calculation. Defaults to \code{model_file} for backward compatibility. When \code{writeTemp=TRUE} in \code{createModel()}, this should be set to the original source file path to ensure hash tracking works correctly when the source file is separate from the compiled model file.}

\item{hash_file}{Name of a file containing a hash key for determining if \code{source_file} has changed since the previous translation and compilation.}

\item{verbose_output}{Boolean specifying whether to write translator messages to standard output. If value is TRUE, messages will be written to standard output; if value is FALSE, messages will be written to files in a temporary directory.}
}
\value{
No return value. Creates files and saves them in locations specified by function arguments.
}
\description{
This function translates MCSim model specification text to C and then
compiles the resulting C file to create a dynamic link library (DLL) file (on
Windows) or a shared object (SO) file (on Unix).
}
