% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-epi-node-decoupled-T.R
\name{spn_T_epi_decoupled_node}
\alias{spn_T_epi_decoupled_node}
\title{Make Transitions (T) For a Node (SEI Mosquitoes)}
\usage{
spn_T_epi_decoupled_node(spn_P, params, cube)
}
\arguments{
\item{spn_P}{set of places produced by \code{\link{spn_P_epi_decoupled_node}} function}

\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with two elements: \code{T} contains transitions packets as lists,
\code{v} is the character vector of transitions (T)
}
\description{
This function makes the set of transitions (T) for a SPN. It is used alone if
our model is a single-node metapopulation of mosquito; otherwise
it is used as part of other functions to make SPN models with larger state
spaces (metapopulation models, see \code{\link{spn_T_epiSIS_network}}).
}
\details{
This function takes the places produced from \code{\link{spn_P_epi_decoupled_node}}
and builds all possible transitions between subsets of those places.

The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, \code{nP}, and \code{nEIP} parameters to be specified. For more details, see
\code{\link{equilibrium_SEI_SIS}}

While this function produces all structural information related to transitions,
hazards are produced by a separate function, \code{\link{spn_hazards}}.
This is used by both decoupled SIS and Imperial transmission model sampling.
For examples of using this function, see:
\code{vignette("epi-node-decoupled", package = "MGDrivE2")}
}
