% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-DM.R
\name{step_DM}
\alias{step_DM}
\title{Make Gillespie's Direct Method (DM) Sampler for a SPN model}
\usage{
step_DM(S, Sout, haz, maxhaz = 1e+06)
}
\arguments{
\item{S}{a stoichiometry \code{\link[Matrix]{Matrix-class}} object}

\item{Sout}{an optional matrix to track of event firings}

\item{haz}{a list of hazard functions}

\item{maxhaz}{maximum allowable hazard}
}
\value{
function closure for use in \code{\link{sim_trajectory_R}} or \code{\link{sim_trajectory_CSV}}
}
\description{
Make a function closure to implement Gillespie's Direct Method sampler for a SPN.
}
\details{
The direct method is an exact sampling algorithm; it simulates each event individually.
Because of this it may be extremely slow for non-trivial population sizes, and
thus should be used to debug and test rather than for serious Monte Carlo simulation.

The design of \code{step_DM} is from: Wilkinson, D. J. (2011). Stochastic
modeling for systems biology. CRC press

Elements of the \code{N} list come from two places: The stoichiometry matrix
(\code{S}) is generated in \code{\link{spn_S}} and the hazards (\code{h}) come
from \code{\link{spn_hazards}}.

For other samplers, see: \code{\link{step_CLE}}, \code{\link{step_PTS}}, \code{\link{step_ODE}}
}
