#' Function Construction
#'
#' This function allows the user to create the target function in an interactive manner. Here, the target function is expressed as
#' \deqn{	f(\boldsymbol{\theta})=f_J(\theta_{1},\ldots,\theta_{p},f_1,\ldots,f_{J-1}),}
#' where
#' \itemize{
#'   \item \eqn{f_1} is a function of \eqn{\theta_{1},\ldots,\theta_{p}};
#'   \item \eqn{f_j} is a function of \eqn{\theta_{1},\ldots,\theta_{p},f_1,\ldots,f_{j-1}}, for \eqn{j=2,\ldots,J};
#'   \item \eqn{f_1,\ldots,f_J} belongs to the bank of assembly functions.
#' }
#' Here, user can input the function by
#' \enumerate{
#'   \item inputting the dimensionality \eqn{p};
#'   \item for \eqn{j=1,\ldots,J};
#'   \enumerate{
#'   \item selecting which assembly function \eqn{f_j} belongs to;
#'   \item inputting the indexes of coefficients or existing functions included as arguments of \eqn{f_j};
#'   \item inputting the coefficients.
#' }
#' }
#'
#'
#' @return
#' An R list depicting the target function.
#'
#' @export
#' @importFrom utils menu
Function_construction<-function()
{
  print("What is the total number of parameters?")
  p<-as.numeric(readline())
  while(!is_natural_number(p))
  {
    print("Please input positive interger.")
    p<-as.numeric(readline())
  }

  Function_obj<-list()
  Function_obj$dimension<-p
  Function_obj$components<-list()
  continue_indicator<-TRUE
  add_position<-0
  all_components<-c("Power","Logarithmic","Logarithmic_one_minus","Exponential","Linear_combination")
  while(continue_indicator)
  {
    add_position<-add_position+1
    choices <- c("Power of linear combination: (ax+by)^c","Logarithm of linear combination: log(ax+by)","Logarithm of 1 minus linear combination: log(1-ax-by)","Exponential of linear combination: exp(ax+by)","Linear combination: ax+by")
    selection <- menu(choices, title = paste0("Please select the function type of No.",add_position," component:"))
    function_selected<-all_components[selection]

    print(paste0("Please input the vector of indexes of parameters or existing functions (interger between -",p," and ",add_position-1,") in the linear combination."))
    input <- readline()
    para <- eval(parse(text=input))
    while(prod(para%in%((-p):(add_position-1)))==0)
    {
      print(paste0("Please input the vector of interger between -",p," and ",add_position-1,"."))
      input <- readline()
      para <- eval(parse(text=input))
    }
    target_length<-length(para)

    if(function_selected=="positive_power")
    {
      print(paste0("Please input the vector of coefficients of the linear combination and the power coefficient."))
      target_length<-length(para)+1
    }else
    {
      print(paste0("Please input the vector of coefficients of the linear combination."))
    }
    input <- readline()
    coeff <- eval(parse(text=input))
    while(any(is.na(coeff))||(length(coeff)!=target_length))
    {
      print(paste0("Please input ",target_length," numeric coefficients."))
      input <- readline()
      coeff <- eval(parse(text=input))
    }
    Function_obj$components[[add_position]]<-list(coefficient=coeff,parameter=para,functions=function_selected)
    selection <- menu(c("Yes","No"), title = paste0("Continue?"))
    continue_indicator<-c(TRUE,FALSE)[selection]
  }
  return(Function_obj)
}
