#' Assembly function: Linear combination function
#'
#' This function evaluates the linear combination function \deqn{f(x_1,x_2,\ldots,x_k)=\sum_{i=1}^kc_ix_{i}.}
#'
#' @param parameter The value of the parameters \eqn{x_1,x_2,\ldots,x_k}.
#' @param coefficient The value of the coefficients \eqn{c_1,c_2,\ldots,c_k}.
#'
#' @return
#' Value of the linear combination function.
#'
#' @keywords internal
#' @noRd
Linear_combination<-function(parameter,coefficient)
{
  return(sum(coefficient*parameter))
}
