% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_dep_t_diff_t.R
\name{d_dep_t_diff_t}
\alias{d_dep_t_diff_t}
\title{Cohen's d from t for Paired Samples Using the SD of Difference Scores}
\usage{
d_dep_t_diff_t(t_value, t = NULL, n, a = 0.05)
}
\arguments{
\item{t_value}{t-statistic from a paired-samples t-test.}

\item{t}{for backwards compatibility, you can also give t.}

\item{n}{Sample size (number of paired observations).}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d_z}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)}
confidence interval for \eqn{d_z}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)}
confidence interval for \eqn{d_z}.}
  \item{n}{Sample size.}
  \item{df}{Degrees of freedom (\eqn{n - 1}).}
  \item{t}{t-statistic.}
  \item{p}{p-value.}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d_z} and its CI.}
  \item{statistic}{APA-style formatted string for reporting
the t-statistic and p-value.}
}
}
\description{
Compute Cohen's \eqn{d_z} from a paired-samples t-statistic and provide a
noncentral-t confidence interval, using the **standard deviation of the
difference scores** as the denominator.
}
\details{
For paired designs, \eqn{d_z} can be obtained directly from the t-statistic:
\deqn{d_z = \frac{t}{\sqrt{n}},}
where \eqn{n} is the number of paired observations (df = \eqn{n-1}). The
\eqn{(1-\alpha)} confidence interval for \eqn{d_z} is derived from the
noncentral t distribution for the observed \eqn{t} and df.

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/deptdifft.html}{Learn more on our example page.}
}
\examples{
# Example derived from the "dept_data" dataset included in MOTE

# Suppose seven people completed a measure before and after an intervention.
# Higher scores indicate stronger endorsement.

    scifi <- t.test(dept_data$before, dept_data$after, paired = TRUE)

# The t-test value was 1.43. You can type in the numbers directly,
# or refer to the dataset, as shown below.

    d_dep_t_diff_t(t_value = 1.43, n = 7, a = .05)

    d_dep_t_diff_t(t_value = scifi$statistic,
        n = length(dept_data$before), a = .05)
}
\keyword{dependent}
\keyword{effect}
\keyword{measures}
\keyword{paired}
\keyword{repeated}
\keyword{sample}
\keyword{size}
\keyword{t-test}
