% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_ind_t_t.R
\name{d_ind_t_t}
\alias{d_ind_t_t}
\alias{d.ind.t.t}
\title{Cohen's d from t for Independent Samples (Pooled SD)}
\usage{
d_ind_t_t(t_value, t = NULL, n1, n2, a = 0.05)

d.ind.t.t(t, n1, n2, a = 0.05)
}
\arguments{
\item{t_value}{t-statistic from an independent-samples t-test.}

\item{t}{t-statistic from an independent-samples t-test.
Used for backwards compatibility.}

\item{n1}{Sample size for group one.}

\item{n2}{Sample size for group two.}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d_s}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)} confidence
interval for \eqn{d_s}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)} confidence
interval for \eqn{d_s}.}
  \item{n1, n2}{Group sample sizes.}
  \item{df}{Degrees of freedom (\eqn{n_1 + n_2 - 2}).}
  \item{t}{t-statistic.}
  \item{p}{p-value.}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d_s} and its CI.}
  \item{statistic}{APA-style formatted string for reporting
the t-statistic and p-value.}
}
}
\description{
**Note on function and output names:**
This effect size is now implemented with the snake_case function name
`d_ind_t_t()` to follow modern R style guidelines. The original dotted
version `d.ind.t.t()` is still available as a wrapper for backward
compatibility, and both functions return the same list. The returned
object includes both the original element names (e.g., `d`, `dlow`,
`dhigh`, `n1`, `n2`, `df`, `t`, `p`, `estimate`, `statistic`) and
newer snake_case aliases (e.g., `d_lower_limit`, `d_upper_limit`,
`sample_size_1`, `sample_size_2`, `degrees_freedom`, `t`,
`p_value`). New code should
prefer `d_ind_t_t()` and the snake_case output names, but existing
code using the older names will continue to work.
}
\details{
Compute Cohen's \eqn{d_s} from an independent-samples
t-statistic and provide a noncentral-t confidence interval,
assuming equal variances (pooled SD).


For between-subjects designs with pooled SD, \eqn{d_s} can
be obtained directly from the t-statistic:
\deqn{d_s = \frac{2t}{\sqrt{n_1 + n_2 - 2}},}
where \eqn{n_1} and \eqn{n_2} are the group sample sizes
(df = \eqn{n_1 + n_2 - 2}).
The \eqn{(1-\alpha)} confidence interval for \eqn{d_s} is derived from the
noncentral t distribution for the observed \eqn{t} and df.

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/indtt.html}{Learn more on our example page.}
}
\examples{
# The following example is derived from the "indt_data" dataset in MOTE.
    hyp <- t.test(correctq ~ group, data = indt_data)

# Direct entry of the t-statistic and sample sizes:
    d_ind_t_t(t = -2.6599, n1 = 4, n2 = 4, a = .05)

# Using the t-statistic from the model object:
    d_ind_t_t(hyp$statistic, length(indt_data$group[indt_data$group == 1]),
              length(indt_data$group[indt_data$group == 2]), .05)
}
\keyword{deviation}
\keyword{effect}
\keyword{independent}
\keyword{pooled}
\keyword{size}
\keyword{standard}
\keyword{t-test}
