% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SignalProcessingUltra.R
\name{SignalProcessingUltra}
\alias{SignalProcessingUltra}
\title{Optimized signal processing for MALDI-TOF spectra (parallel + optional C++ alignment)}
\usage{
SignalProcessingUltra(
  x,
  transformIntensity_method = "log",
  smoothing_method = "Wavelet",
  removeBaseline_method = "TopHat",
  removeBaseline_iterations = 25,
  calibrateIntensity_method = "PQN",
  alignSpectra_NoiseMethod = "MAD",
  alignSpectra_method = c("cubic", "lowess", "landmark_cpp"),
  alignSpectra_halfWs = 11,
  alignSpectra_SN = 3,
  tolerance_align = 0.002,
  ppm_align = FALSE,
  referenceSpectra = NULL,
  minFrequency = 0.7,
  binPeaks_method = "strict",
  keepReferenceSpectra = FALSE,
  n_workers = NULL,
  ref_sample_n = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{list of MALDIquant MassSpectrum objects.}

\item{transformIntensity_method}{character, intensity transform (default "log").}

\item{smoothing_method}{character, smoothing method ("Wavelet" UDWT).}

\item{removeBaseline_method}{character, baseline method ("TopHat" default; "SNIP","ConvexHull" supported).}

\item{removeBaseline_iterations}{integer, SNIP iterations if removeBaseline_method = "SNIP".}

\item{calibrateIntensity_method}{character, intensity calibration ("PQN" default, or "TIC","median").}

\item{alignSpectra_NoiseMethod}{character, noise estimator for peak finding pre-alignment ("MAD").}

\item{alignSpectra_method}{character, alignment engine: "cubic" (default), "lowess", or "landmark_cpp".}

\item{alignSpectra_halfWs}{integer, half window size for peak detection.}

\item{alignSpectra_SN}{numeric, SNR for peak detection.}

\item{tolerance_align}{numeric, tolerance for matching anchors to the reference during alignment.
Use consistent units across your pipeline (Da by default here).}

\item{ppm_align}{logical, set TRUE if tolerance_align is in ppm (then interpreted as ppm).}

\item{referenceSpectra}{optional MALDIquant MassPeaks object to use as alignment reference.}

\item{minFrequency}{numeric, minimum peak frequency to build reference if not provided (default 0.7).}

\item{binPeaks_method}{character, "strict" (default) or "relaxed" for reference peak binning.}

\item{keepReferenceSpectra}{logical, if TRUE and no reference provided, returns list(spectra=..., RefS=...).}

\item{n_workers}{integer, number of parallel workers (default: all cores minus one).}

\item{ref_sample_n}{integer or NULL, if set, build the reference from a random subset of this many spectra.}

\item{verbose}{logical, print progress.}

\item{...}{passed to MALDIrppa::wavSmoothing (e.g., n.levels).}
}
\value{
A list of MassSpectrum objects, or a list with $spectra and $RefS if keepReferenceSpectra = TRUE.
}
\description{
This function performs post-acquisition processing for lists of MALDIquant MassSpectrum objects.
It parallelizes per-spectrum steps and can align with either MALDIquant's warping (cubic/lowess)
or a fast landmark-based C++ algorithm ("landmark_cpp").
}
