% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.MaddisonLeaders.R
\name{summary.MaddisonLeaders}
\alias{summary.MaddisonLeaders}
\title{Summary method for an object of class \code{MaddisonLeaders}}
\usage{
\method{summary}{MaddisonLeaders}(object, sortBy = "ISO", decreasing = FALSE, ...)
}
\arguments{
\item{object}{= object of class \code{MaddisonLeaders}.}

\item{sortBy}{= column of output used for sorting; default = \code{ISO}}

\item{decreasing}{default = \code{FALSE}}

\item{...}{= optional arguments for \code{summary} (not used)}
}
\value{
a \code{\link{data.frame}} with columns

\itemize{
\item \code{ISO} = One row for each level of \code{ISO} in \code{unique(object[, 'ISO'])}
\item \verb{paste0(x, 'Begin)} = earliest \code{object[, paste0(x, 'Begin')]} for \code{ISO}
\item \code{paste0(x, 'End')}, last \code{object[, paste0(x, 'End')]} for \code{ISO}
\item \code{n} = sum of \verb{(paste0(x, 'End')} - \code{paste0(x, 'Begin') + 1} for \code{ISO}.
\item \code{p} = \code{n/(paste0(x, 'End') - paste0(x, 'Begin') + 1)}.
})

(defaults:
\itemize{
\item \code{ISO} = One row for each level of \code{ISO} in \code{unique(object[, 'ISO'])}
\item \code{yearBegin} = earliest \verb{object[, 'yearBegin')]} for \code{ISO}
\item \code{yearEnd} = last \verb{object[, 'yearEnd')]} for \code{ISO}
\item \code{n} = sum of \code{('yearEnd' - 'yearBegin' + 1)} for \code{ISO}.
\item \code{p} = \code{n/(yearEnd - yearBegin + 1)}.
}

[, 'yearBegin')]: R:,\%20'yearBegin')
[, 'yearEnd')]: R:,\%20'yearEnd')
}
\description{
\code{summary.MaddisonLeaders} returns a \code{\link{data.frame}} with columns \code{ISO},
\verb{paste0(x, 'Begin)}, \code{paste0(x, 'End')}, \code{n}, and \code{p}.
}
\examples{
Leaders0 <- MaddisonLeaders() # max GDPpc for each year. 
summary(Leaders0) 

}
\keyword{manip}
