#' @name raw
#' @title Metabolomics data set
#' @description This data set contains a matrix of log10-transformed ion intensities from a maize root metabolomics study for in total 112 metabolites in 120 samples.
#' @docType data
#' @author Jan Lisec \email{jan.lisec@@bam.de}
#' @source <https://onlinelibrary.wiley.com/doi/10.1111/j.1365-313X.2011.04689.x>
#' @keywords data
"raw"

#' @name met
#' @title Metabolite table
#' @description This data frame contains the metabolite definition of 112 metabolites according to the cols of \link{raw}.
#' @docType data
#' @author Jan Lisec \email{jan.lisec@@bam.de}
#' @source <https://onlinelibrary.wiley.com/doi/10.1111/j.1365-313X.2011.04689.x>
#' @keywords data
"met"

#' @name sam
#' @title Sample table
#' @description This data frame contains the sample definition of 120 samples according to the rows of \link{raw}.
#' @docType data
#' @author Jan Lisec \email{jan.lisec@@bam.de}
#' @source <https://onlinelibrary.wiley.com/doi/10.1111/j.1365-313X.2011.04689.x>
#' @keywords data
"sam"
