% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Interact.dyvis}
\alias{Interact.dyvis}
\title{Dynamic Visualization of Microbial Interaction Networks}
\usage{
Interact.dyvis(
  Interact_data,
  threshold,
  core_arrow_num,
  Taxa = NULL,
  fontsize = 15
)
}
\arguments{
\item{Interact_data}{A list containing the inferred species interaction results generated by \code{\link[MicrobTiSDA]{Spec.interact}}.}

\item{threshold}{Indicates the minimum interaction coefficient used to visualize species interactions. The default value is 1e-6.}

\item{core_arrow_num}{Indicates the number of species pairs involved in species interactions that identify keystone species. The default value is 4,
meaning that the screened keystone species must interact with three other species populations in addition to its own population.}

\item{Taxa}{A data frame providing taxonomic annotations for microbial species.}

\item{fontsize}{Indicates the size of the text font. The default is 15.}
}
\value{
An S3 objects of species interact information or plots.
}
\description{
This function visualizes microbial species interactions based on the given inter-species interaction results by \code{\link[MicrobTiSDA]{Spec.interact}}.
}
\details{
The function processes microbial interaction matrices from \code{\link[MicrobTiSDA]{Spec.interact}} to construct species interaction networks.
It selects edges with absolute interaction strengths above \code{threshold}, assigns interaction types (positive or negative).
The function supports onpional taxonomic annotations for improved interpretability.

The nodes represent microbial species,. Edge colors indicate interaction types:
blue for negative and orange for positive interactions. Edge widths are scaled by interaction strength. If taxonomic annotations are provided,
node labels reflect species-level taxonomy; otherwise, OTU/ASV IDs are used.
}
\author{
Shijia Li
}
