% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{track_wkflow_samples}
\alias{track_wkflow_samples}
\title{Track the number of reads (= sequences), samples and cluster (e.g. ASV)
for each sample}
\usage{
track_wkflow_samples(list_pq_obj, ...)
}
\arguments{
\item{list_pq_obj}{(required) a list of object passed on to \code{\link[=track_wkflow]{track_wkflow()}}
Only phyloseq object will return value because information of sample is needed}

\item{...}{Other args passed on to \code{\link[=track_wkflow]{track_wkflow()}}}
}
\value{
A list of dataframe. cf \code{\link[=track_wkflow]{track_wkflow()}} for more information
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Contrary to \code{\link[=track_wkflow]{track_wkflow()}}, only phyloseq object are possible.
More information are available in the manual of the function \code{\link[=track_wkflow]{track_wkflow()}}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") withAutoprint(\{ # examplesIf}
tree_A10_005 <- subset_samples(data_fungi, Tree_name == "A10-005")
if (requireNamespace("pbapply")) {
  track_wkflow_samples(tree_A10_005)
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
