% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogconc.R
\name{mixLogconc}
\alias{mixLogconc}
\title{Clustering with Mixtures of Log-concave Distributions using EM Algorithm (Univariate)}
\usage{
mixLogconc(x, C = 2, ini = NULL, nstart = 20, tol = 1e-05)
}
\arguments{
\item{x}{an n by 1 data matrix where n is the number of observations.}

\item{C}{number of mixture components. Default is 2.}

\item{ini}{initial value for the EM algorithm. Default value is NULL, which
obtains the initial value using the \code{\link{EMnormal}} function. It can be a list
with the form of \code{list(pi, mu, sigma)}, where \code{pi} is a 1 by C matrix
of mixing proportions, \code{mu} is a C by 1 matrix of component means, and
\code{sigma} is a p by p by 1 array of standard deviations or covariance matrices
of \code{C} mixture components.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{stopping criteria (threshold value) for the EM algorithm. Default is 1e-05.}
}
\value{
A list containing the following elements:
\item{loglik}{final log-likelihood.}
\item{pi}{estimated mixing proportions.}
\item{f}{component densities at x.}
}
\description{
`mixLogconc' is used to estimate the parameters of a mixture of univariate
log-concave distributions.
}
\examples{
set.seed(4)
x = matrix(rnorm(100, 2, sqrt(2)), nrow = 100)
x[1:60] = x[1:60] + 5
EMlogc = mixLogconc(x, C = 2)
}
\references{
Chang, G. T., and Walther, G. (2007). Clustering with mixtures of log-concave
distributions. Computational Statistics & Data Analysis, 51(12), 6242-6251.

Hu, H., Wu, Y., and Yao, W. (2016). Maximum likelihood estimation of the mixture
of log-concave densities. Computational Statistics & Data Analysis, 101, 137-147.
}
\seealso{
\code{\link{EMnormal}}, \code{\link{mixLogconcHD}}
}
