% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiregGLEM.R
\name{semimrGen}
\alias{semimrGen}
\title{Semiparametric Mixture Data Generator}
\usage{
semimrGen(n, p = 0.5, var = c(.1, .1), u)
}
\arguments{
\item{n}{a scalar, specifying the number of observations in \eqn{x}.}

\item{p}{a scalar, specifying the probability of an observation belonging to the first component,
i.e., \eqn{p} in the model.}

\item{var}{a vector of variances of observations for the two components.}

\item{u}{a vector of grid points for \eqn{x}. If some specific explanatory variable are needed, create a vector and assign to \code{u}.}
}
\value{
A list containing the following elements:
\item{x}{vector of length n, which represents the explanatory variable
that is randomly generated from Uniform(0,1).}
\item{y}{vector of length n, which represent the response variable
that is generated based on the mean functions \eqn{m_1(x)} and \eqn{m_2(x)},
with the addition of normal errors having a mean of 0 and a standard deviation specified by the user.}
\item{true_mu}{n by 2 matrix containing the values of \eqn{m_1(x)} and \eqn{m_2(x)} at x.}
\item{true_mu_u}{length(u) by 2 matrix containing the values of \eqn{m_1(x)} and \eqn{m_2(x)} at u.}
}
\description{
`semimrGen' is used to generate data for a two-component semiparametric mixture of regression models:
\deqn{p m_1(x) + (1-p) m_2(x),}
where \eqn{m_1(x) = 4 -\sin(2\pi x)} and \eqn{m_2(x) = 1.5 + \cos(3\pi x).}
This function is used in the examples for the \code{\link{semimrLocal}} and \code{\link{semimrGlobal}} functions.
See the examples for details.
}
\examples{
n = 100
u = seq(from = 0, to = 1, length = 100)
true_p = c(0.3, 0.7)
true_var = c(0.09, 0.16)
out = semimrGen(n = n, p = true_p[1], var = true_var, u = u)
}
\seealso{
\code{\link{semimrLocal}}, \code{\link{semimrGlobal}}, \code{\link{semimrBinFull}}
}
