% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcculloch.R
\name{generate_mcculloch_table}
\alias{generate_mcculloch_table}
\title{Generate McCulloch lookup table from simulated stable samples}
\usage{
generate_mcculloch_table(alpha_grid, beta_grid, size = 1e+05)
}
\arguments{
\item{alpha_grid}{Vector of alpha values to simulate.}

\item{beta_grid}{Vector of beta values to simulate.}

\item{size}{Number of samples per simulation.}
}
\value{
Named list of quantile ratios indexed by "alpha_beta".
}
\description{
Simulates alpha-stable samples across a grid of alpha and beta values, and computes
quantile-based ratios used for McCulloch estimation. The result is a lookup table
indexed by (alpha, beta) keys.
}
