# Clean environment and load libraries
rm(list = ls())  # Clear environment to avoid conflicts

# Source files
library(MixStable)

# Generate synthetic data
data <- rstable(1000, alpha = 1.5, beta = 0.5, 1.2, 2.0)

# Run Gibbs sampling
n_samples <- if (identical(Sys.getenv("NOT_CRAN"), "true")) 100 else 20
gibbs_result <- mock_gibbs_sampling(data, n_samples = n_samples, verbose = FALSE)

# Display best parameters
print(gibbs_result$best_params)
