% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.morpho.R
\name{plot.morpho}
\alias{plot.morpho}
\title{Plot full evolutionary history}
\usage{
\method{plot}{morpho}(
  x = NULL,
  trait = NULL,
  timetree = FALSE,
  show.fossil = FALSE,
  reconstructed = FALSE,
  root.edge = FALSE,
  edge.width = 1,
  label.offset = 0.05,
  e.cex = 0.5,
  f.cex = 1,
  box.cex = 4,
  col = c("#fdfdfd", "lightgray", "lightblue", "pink", "yellow", "green", "orange"),
  col.timescale = "darkgrey",
  ...
)
}
\arguments{
\item{x}{A morpho object}

\item{trait}{The trait number to plot.}

\item{timetree}{TRUE or FALSE. Indicate whether you want to plot a time
tree or not. Default = FALSE (uses distance tree if FALSE).}

\item{show.fossil}{Plot the fossil along the tree. Default = FALSE.}

\item{reconstructed}{Plot the reconstructed tree. Default = FALSE.}

\item{root.edge}{If TRUE plot the root edge. Default = FALSE.}

\item{edge.width}{Width of the branches.}

\item{label.offset}{Distance of tip label to tree tips.}

\item{e.cex}{Size of extant taxa.}

\item{f.cex}{Size of fossils.}

\item{box.cex}{Size of traits on plot}

\item{col}{A vector of colors that should be the same length or longer than
the number of different character states (k). If not specified, the traits
from 0 to 6 can be differentiated.}

\item{col.timescale}{A single color for the timescale. Default = "darkgrey".}

\item{...}{Other arguments to be passed to methods, such as graphical
parameters.}
}
\value{
No return value, called for its side effect of producing a plot.
}
\description{
This function creates a plot showing continuous evolution of discrete traits.
}
\examples{
# simulate a phylogenetic tree
data(morpho_data)
plot(morpho_data, trait = 4, timetree = FALSE, show.fossil = FALSE,
     root.edge = FALSE, reconstructed = FALSE)

}
