% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMorphoGrid.R
\name{plotMorphoGrid}
\alias{plotMorphoGrid}
\title{Plots morphological matrix}
\usage{
plotMorphoGrid(
  data = NULL,
  timetree = FALSE,
  seq = "tips",
  num.trait = "all",
  col = c("lavender", "white", "lightskyblue1", "pink", "gold2", "forestgreen", "coral")
)
}
\arguments{
\item{data}{A morpho object}

\item{timetree}{TRUE or FALSE Indicate whether you want to plot a time tree or not. default FALSE, uses distance tree if FALSE}

\item{seq}{the sequence data to plot: "tips", "nodes", "SA", or "recon"}

\item{num.trait}{default is set to "all" which plots all traits in black font. If you
want to focus on a specific trait set it here, e.g. num.trait = 1 and this trait will
be highlighted}

\item{col}{A vector of colors that should be the same length or longer than the number of different character states (k). if not specified, the traits from 0 to 6 can be differentiated}
}
\value{
No return value, called for its side effect of producing a plot.
}
\description{
This function plots the full morphological matrix assocaited with the character data
at the tips of a tree. Requires a morpho object as input.
}
\examples{
data(morpho_data)
# plot the character matrix
plotMorphoGrid(data = morpho_data, seq = "tips", num.trait = "all")
}
