% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareMplusData.R
\name{.cleanHashData}
\alias{.cleanHashData}
\alias{.hashifyFile}
\title{Clean data and calculate the md5 hash}
\usage{
.cleanHashData(df, keepCols = NULL, dropCols = NULL, imputed = FALSE)

.hashifyFile(filename, hash, useexisting = FALSE)
}
\arguments{
\item{df}{The R data.frame to be prepared for Mplus}

\item{keepCols}{A character vector specifying the variable names
within \code{df} to be output to \code{filename} or a numeric
vector of the column indices to be output or a logical vector
corresponding to the same.}

\item{dropCols}{A character vector specifying the variable names
within \code{df} to be omitted from the data output to \code{filename}
or a numeric vector of the column indices not to be output
or a logical vector corresponding to the same.}

\item{imputed}{A logical whether data are multiply imputed.  Defaults
to \code{FALSE}.  If \code{TRUE}, the data should be a list,
where each element of the list is a multiply imputed dataset.}

\item{filename}{A character vector containing the filename}

\item{hash}{A character vector with the hash to use}

\item{useexisting}{A logical whether to use an existing file name
if one is found containing the hash.  Defaults to \code{FALSE}
in which case the hash is added to the user specified filename}
}
\value{
A list of the data and the md5 hash.

A list of the filename (plus hash) and a logical value
whether a filename with the hash already existed or not.
}
\description{
Internal utility function, primarily for \code{prepareMplusData}.

Internal utility function, primarily for \code{prepareMplusData}.
}
\examples{
\dontrun{

## basic example
MplusAutomation:::.cleanHashData(mtcars)

## has changes when data changes
MplusAutomation:::.cleanHashData(mtcars[-15,])

## example on a list (e.g., for multiply imputed data)

MplusAutomation:::.cleanHashData(
 list(
   data.frame(a = 1:4),
   data.frame(a = c(2, 2, 3, 4))),
  imputed = TRUE)

}
MplusAutomation:::.hashifyFile("testit.dat", "abc")
}
\keyword{internal}
