PolychorMatrix<- function(X, thresholds=TRUE, ML=FALSE){
  I=dim(X)[1]
  J=dim(X)[2]
  R=matrix(1, J,J)
  Thresholds=list()
  
  for (i in 1:(J-1))
    for (j in (i+1):J){
      poly=polycor::polychor(X[,i], X[,j], thresholds=thresholds, ML=ML)
      R[i,j]=poly$rho
      R[j,i]=poly$rho
      Thresholds[[i]]=poly$row.cuts
    }
  Thresholds[[j]]=poly$col.cuts
  rownames(R)=colnames(X)
  colnames(R)=colnames(X)
  names(Thresholds)=colnames(X)
  result=list(R=R, Thresholds=Thresholds)
  return(result)
}
