% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{selectFac.MultiRFM}
\alias{selectFac.MultiRFM}
\title{Select the number of factors}
\usage{
selectFac.MultiRFM(
  XList,
  q_max = 15,
  qs_max = 4,
  method = c("SSVR", "CUP"),
  threshold = 1e-05,
  cup.upper = 0.95,
  epsELBO = 1e-05,
  maxIter = 30,
  verbose = TRUE,
  seed = 1
)
}
\arguments{
\item{XList}{A length-M list, where each component represents a matrix and is the}

\item{q_max}{an optional integer, specify the maximum number of study-shared factors; default as 15.}

\item{qs_max}{an optional integer, specify the maximum number of study-specified factors; default as 4.}

\item{method}{an optional character, contains the methods of "SSVR" and "CUP", where `SSVR` is the sequential singular value ratio method while `CUP` is the criterion based on cumulative proportion of explained variance.}

\item{threshold}{the cutoff of the singular values, where the singular values less than this value will be removed.}

\item{cup.upper}{upper limit of the cumulative proportion of explained variance.}

\item{epsELBO}{an optional positive value, tolerance of relative variation rate of the evidence lower bound value, defualt as '1e-5'.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{seed}{an optional integer, specify the random seed for reproducibility in initialization;default as 1.}
}
\value{
return a list contains the following components:(1) q, the number of shared factors; (2) qs,the number of specified factors.
}
\description{
Select the number of factors that are shared among studies q and thos that are specific to individual studies(qs).More details are in Section 3.1 of the article.
}
\details{
None
}
\examples{
p <- 100
nvec <- c(150,200); qs <- c(2,2)
datList <- gendata_simu_multi(seed=1, nvec=nvec, p=p, q=3, qs=qs, rho=c(5,5),
        err.type='mvt', sigma2_eps = 1, nu=3)
XList <- datList$Xlist;
## Set maxIter=5 for demonstration while set it to 30 in the formal run.
hqlist <- selectFac.MultiRFM(XList, q_max=6, qs_max= rep(4,2), maxIter = 5) #
str(hqlist)



}
