% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{CommutatorMatr}
\alias{CommutatorMatr}
\title{Commutator Matrix}
\usage{
CommutatorMatr(Type, ...)
}
\arguments{
\item{Type}{A string specifying the type of commutator matrix. Choices are "Kmn", "Kperm", "Mixing", or "Moment".}

\item{...}{Additional arguments specific to the type of commutator matrix (see Details).}
}
\value{
Depending on the  type:
\describe{
  \item{Kmn}{A commutation matrix of dimension \eqn{mn \times mn}. If \code{useSparse=TRUE}, an object of class "dgCMatrix" is produced.}
  \item{Kperm}{A square permutation matrix of size \code{prod(dims)}. If \code{useSparse=TRUE}, an object of class "dgCMatrix" is produced.}
  \item{Mixing}{A square matrix of dimension \code{prod(d1) * prod(d2)}. If \code{useSparse=TRUE}, an object of class "dgCMatrix" is produced.}
  \item{Moment}{A commutator matrix for moment formulae.}
}
}
\description{
This function generates various types of commutator matrices.
}
\details{
The function \code{CommutatorMatr} supports the following types of commutator matrices:

\describe{
  \item{Kmn}{
    \strong{Description:} Transforms \code{vec(A)} to \code{vec(A^T)}, where \code{A^T} is the transpose of matrix \code{A}. An option for sparse matrix is provided. By default, a non-sparse matrix is produced. Using sparse matrices increases computation times but requires far less memory.
    \strong{Arguments:}
    \describe{
      \item{\code{m} (integer)}{Number of rows of the first matrix.}
      \item{\code{n} (integer)}{Number of columns of the first matrix.}
      \item{\code{useSparse} (logical, optional)}{If TRUE, returns a sparse matrix. Default is FALSE.}
    }
  }
  \item{Kperm}{
    \strong{Description:} Generates a commutation matrix for a specified permutation of matrix dimensions. An option for sparse matrix is provided. By default, a non-sparse matrix is produced. Using sparse matrices increases computation times but requires far less memory.
    \strong{Arguments:}
    \describe{
      \item{\code{perm} (integer vector)}{The permutation vector.}
      \item{\code{dims} (integer vector)}{The dimensions of the vectors in the tensor product  involved.}
      \item{\code{useSparse} (logical, optional)}{If TRUE, returns a sparse matrix. Default is FALSE.}
    }
  }
  \item{Mixing}{
    \strong{Description:} Generates the Mixing commutation matrix used in linear algebra transformations involving tensor products. An option for sparse matrix is provided. By default, a non-sparse matrix is produced. Using sparse matrices increases computation times but requires far less memory.
    \strong{Arguments:}
    \describe{
      \item{\code{d1} (integer vector)}{Dimensions of the first set.}
      \item{\code{d2} (integer vector)}{Dimensions of the second set.}
      \item{\code{useSparse} (logical, optional)}{If TRUE, returns a sparse matrix. Default is FALSE.}
    }
  }
  \item{Moment}{
    \strong{Description:} Generates the Moment commutation matrix based on partitioning of moments. An option for sparse matrix is provided. By default, a non-sparse matrix is produced. Using sparse matrices increases computation times but requires far less memory.
    \strong{Arguments:}
    \describe{
      \item{\code{el_rm} (integer vector)}{Elements of the partition.}
      \item{\code{d} (integer)}{Dimension of the partition.}
      \item{\code{useSparse} (logical, optional)}{If TRUE, returns a sparse matrix. Default is FALSE.}
    }
  }
}
}
\examples{
# Example for Kmn
CommutatorMatr("Kmn", m = 3, n = 2)

# Example for Kperm
dims <- c(2, 3, 2)
perm <- c(1, 3, 2)
CommutatorMatr("Kperm", perm = perm, dims = dims)

# Example for Mixing
d1 <- c(2, 3, 2)
d2 <- c(3, 2, 2)
CommutatorMatr("Mixing", d1 = d1, d2 = d2)

# Example for Moment
n <- 4
r <- 2
m <- 1
d <- 2
PTA <- PartitionTypeAll(n)
el_r <- PTA$eL_r[[r]][m,]
CommutatorMatr("Moment", el_r = el_r, d = d)
}
\seealso{
Other Commutators: 
\code{\link{CommutatorIndx}()}
}
\concept{Commutators}
