% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecursionF.r
\name{IntGramCharlier}
\alias{IntGramCharlier}
\title{Integrate Gram Charlier density}
\usage{
IntGramCharlier(x, cum, type = c("lower", "upper"))
}
\arguments{
\item{x}{An nxd data matrix}

\item{cum}{Unstandardized first four cumlants}

\item{type}{Character string specifying the integration range.
Must be one of:
\itemize{
  \item \code{"lower"}: integrate from \eqn{-\infty} to \eqn{x}
  \item \code{"upper"}: integrate from \eqn{x} to \eqn{+\infty}
}}
}
\value{
The vector of evaluated probabilities
}
\description{
Computes the integrals of the \eqn{d}-variate Gram Charlier  density
with respect to the normal density
It integrates the \code{\link{GramCharlier}} with the first 4
cumulants.
}
\examples{
x <- matrix(1:6,2,3, byrow=TRUE)
cum <- MomCumMVt(p = 12, d = 3, r = 4, nCum = TRUE)
# P(X <= x)
p <- IntGramCharlier(x, cum, type = "lower")

}
\seealso{
Other Approximations: 
\code{\link{Edgeworth}()},
\code{\link{GramCharlier}()},
\code{\link{IntEdgeworth}()},
\code{\link{MTCE}()}
}
\concept{Approximations}
