% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NADA_ros.R
\name{ros}
\alias{ros}
\alias{plot.ros}
\title{Regression on Order Statistics (ROS)}
\usage{
ros(
  obs,
  censored = NULL,
  data = NULL,
  forwardT = "log",
  reverseT = "exp",
  na.action = getOption("na.action")
)

\method{plot}{ros}(
  x,
  plot.censored = FALSE,
  lm.line = TRUE,
  grid = TRUE,
  ylab = "Value",
  pch = 16,
  ...
)
}
\arguments{
\item{obs}{Numeric vector of observations or formula of the form \code{response ~ censor}, where \code{response} is numeric values and \code{censor} is a logical or binary indicator (TRUE if censored).}

\item{censored}{Logical vector of left-censored indicators.}

\item{data}{A \code{data.frame} containing the variables in the formula.}

\item{forwardT}{Name of transformation function (e.g., "log", "trueT").}

\item{reverseT}{Name of back-transformation function (e.g., "exp", "trueT").}

\item{na.action}{Function to handle missing values.}

\item{x}{ros2 model object}

\item{plot.censored}{default = FALSE, if set to true it will also plot censored data}

\item{lm.line}{will plot linear model line}

\item{grid}{will add grid}

\item{ylab}{default is "Value" but custom text can be added}

\item{pch}{default set to 16, codes consistent with \code{points} and \code{plot} functions}

\item{...}{arguments passed to plot function}
}
\value{
A list with:
\describe{
\item{\code{modeled}}{Numeric vector of uncensored + imputed censored values.}
\item{\code{modeled.censored}}{Imputed values only for censored observations.}
\item{\code{uncensored}}{Original uncensored values.}
\item{\code{censored}}{Original censored values.}
\item{\code{censored.ranks}}{Censored ranks used in estimation.}
\item{\code{uncensored.ranks}}{Uncensored ranks used in estimation.}
\item{\code{model}}{Fitted linear model object.}
}
}
\description{
Perform regression on order statistics for left-censored data.
}
\details{
Code for this function is originally from the NADA package developed by R. Lopaka Lee and Dennis Helsel.
By default, ros performs a log transformation prior to, and after operations over the data.
This can be changed by specifying a forward and reverse transformation function using the forwardT
and reverseT parameters. No transformation will be performed if either forwardT or reverseT are set to NULL.

The procedure first computes the Weibull-type plotting positions of the combined uncensored
and censored observations using a formula designed for multiply-censored data (see hc_ppoints).
A linear regression is formed using the plotting positions of the uncensored observations and
their normal quantiles. This model is then used to estimate the concentration of the censored
observations as a function of their normal quantiles. Finally, the observed uncensored values
are combined with modeled censored values to corporately estimate summary statistics of the entire
population. By combining the uncensored values with modeled censored values, this method is more
resistant of any non-normality of errors, and reduces any transformation errors that may be incurred.
}
\examples{
df <- data.frame(
  conc = c(0.2, 0.5, 1.0, 0.4, 2.0, 0.3),
  censored = c(TRUE, TRUE, FALSE, TRUE, FALSE, TRUE)
)
ros(conc ~ censored, data = df)

}
