#' Construct EL Result Object
#' @keywords internal
new_nmar_result_el <- function(y_hat, se, weights, coefficients, vcov,
                               converged, diagnostics, inputs,
                               nmar_scaling_recipe, fitted_values, call,
                               formula = NULL) {
  diagnostics <- diagnostics %||% list()
  outcome_name <- inputs$outcome_expr %||% NA_character_
  trim_fraction <- diagnostics$trimmed_fraction %||% NA_real_
  is_svy <- inherits(inputs$analysis_data, "survey.design")

  sample <- list(
    n_total = inputs$N_pop %||% NA_integer_, # weights(object, scale='population') sums to this
    n_respondents = sum(inputs$respondent_mask) %||% NA_integer_,
    is_survey = isTRUE(is_svy),
    design = if (isTRUE(is_svy)) inputs$analysis_data else NULL
  )

  df_val <- NA_real_
  if (isTRUE(sample$is_survey) && !is.null(sample$design) && requireNamespace("survey", quietly = TRUE)) {
    df_val <- tryCatch(survey::degf(sample$design), error = function(e) NA_real_)
  }

  if (!is.list(coefficients)) {
    response_coeffs <- NULL
    nuisance_terms <- list()
  } else {
    response_coeffs <- coefficients$response_model %||% NULL
    nuisance_terms <- coefficients$nuisance %||% list()
  }

  inference <- list(
    variance_method = inputs$variance_method %||% NA_character_,
    df = df_val,
    message = diagnostics$vcov_message %||% NA_character_
  )

  meta <- list(
    engine_name = "empirical_likelihood",
    call = call,
    formula = formula
  )

  result <- new_nmar_result(
    estimate = y_hat,
    estimate_name = outcome_name,
    se = se,
    converged = converged,
    model = list(
      coefficients = response_coeffs,
      vcov = vcov,
      nuisance = nuisance_terms
    ),
    weights_info = list(values = weights, trimmed_fraction = trim_fraction),
    sample = sample,
    inference = inference,
    diagnostics = diagnostics,
    meta = meta,
    extra = list(
      nuisance = nuisance_terms,
      nmar_scaling_recipe = nmar_scaling_recipe,
      fitted_values = fitted_values
    ),
    class = "nmar_result_el"
  )

  result
}
