% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_input.R
\name{el_prepare_inputs}
\alias{el_prepare_inputs}
\title{Input preprocessing}
\usage{
el_prepare_inputs(
  formula,
  data,
  weights = NULL,
  n_total = NULL,
  design_object = NULL
)
}
\description{
Parses the two-part Formula, constructs EL design matrices, injects the
respondent delta indicator, attaches weights and survey metadata,
and returns the pieces needed by the EL core.
}
\details{
Enforeces the following format required by the rest of el code:
\itemize{
\item LHS references exactly one outcome source variable in \code{data}; any
transforms are applied via the formula environment and must be defined
for all respondent rows.
\item The outcome is never allowed to appear on RHS1 (auxiliaries) or RHS2
(missingness predictors), either explicitly in the formula or implicitly
via dot (\code{.}) expansion. The missingness model uses the evaluated LHS
expression as a dedicated predictor column instead.
\item RHS1 always yields an intercept-free auxiliary design matrix with
k-1 coding for factor auxiliaries, regardless of user \code{+0}/\code{-1} syntax or
custom contrasts. Auxiliary columns are validated to be fully observed
and non-constant among respondents.
\item RHS2 always yields a missingness-design matrix for respondents that
includes an intercept column and zero-variance predictors emit
warnings. NA among respondents is rejected.
\item \code{respondent_mask} is defined from the raw outcome in \code{data}, not from
the transformed LHS. An injected \code{..nmar_delta..} indicator in
\code{analysis_data} must match this mask.
\item \code{N_pop} is the analysis-scale population size:
for IID it is \code{nrow(data)} unless overridden by \code{n_total}.
For survey designs it is \code{sum(weights)} or \code{n_total} when supplied.
}
}
\keyword{internal}
